package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.TaskReportApprovalDto;

public class TaskReportApprovalDao extends AbstractDao {
    private static final String TAG = "TaskReportApprovalDao";

    /*package*/ TaskReportApprovalDao() {
    }

    @Override
    protected TaskReportApprovalDto convert(Cursor cursor) {
        TaskReportApprovalDto dto = new TaskReportApprovalDto();
        int column = cursor.getColumnIndex("process_key");
        if (column != -1) {
            dto.processKey = cursor.getString(column);
        }
        column = cursor.getColumnIndex("phase_no");
        if (column != -1) {
            dto.phaseNo = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("approval_group_id");
        if (column != -1) {
            dto.approvalGroupId = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("approval_group_name");
        if (column != -1) {
            dto.approvalGroupName = cursor.getString(column);
        }
        column = cursor.getColumnIndex("approval_name");
        if (column != -1) {
            dto.approvalName = cursor.getString(column);
        }
        column = cursor.getColumnIndex("approval_no");
        if (column != -1) {
            dto.approvalNo = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("comment");
        if (column != -1) {
            dto.comment = cursor.getString(column);
        }
        column = cursor.getColumnIndex("sendback_phase_no");
        if (column != -1) {
            dto.sendbackPhaseNo = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("signature");
        if (column != -1) {
            dto.signature = cursor.getString(column);
        }
        column = cursor.getColumnIndex("status");
        if (column != -1) {
            dto.status = cursor.getInt(column);
        }
        return dto;
    }

    public List<TaskReportApprovalDto> selectTaskReportApprovalByProcessKey(String processKey, Integer phaseNo) {
        return rawQueryGetDtoList("select * from t_task_report_approval where process_key = ? and phase_no = ? order by approval_no asc", new String[]{processKey, "" + phaseNo}, TaskReportApprovalDto.class);
    }

    public TaskReportApprovalDto selectTaskReportApprovalByProcessKey(String processKey, Integer phaseNo, Integer approval_no) {
        return rawQueryGetDto("select * from t_task_report_approval where process_key = ? and phase_no = ? and approval_no = ? ", new String[]{processKey, "" + phaseNo,""  + approval_no}, TaskReportApprovalDto.class);
    }

    public void insert(TaskReportApprovalDto dto) {
        insert("insert into t_task_report_approval "
                        + "(process_key, "
                        + "phase_no, "
                        + "approval_group_id, "
                        + "approval_group_name, "
                        + "approval_name, "
                        + "approval_no, "
                        + "comment, "
                        + "sendback_phase_no, "
                        + "signature, "
                        + "status) "
                        + "values "
                        + "(?,?,?,?,?,?,?,?,?,?)",
                dto.getInsertValues());
    }

    public boolean update(TaskReportApprovalDto dto) {
        long count = update("update t_task_report_approval "
                        + "set "
                        + "approval_group_id=?, "
                        + "approval_group_name=?, "
                        + "approval_name=?, "
                        + "approval_no=?, "
                        + "comment=?, "
                        + "sendback_phase_no=?, "
                        + "signature=?, "
                        + "status=? "
                        + "where process_key=? "
                        + "and phase_no=? "
                        + "and approval_no=? ",
                dto.getUpdateValues());
        return count > 0;
    }

    /**
     * テーブル物理削除
     * @param processKey 工程キー
     */
    public void delete(String processKey) {
        delete("t_task_report_approval", "process_key=?", new String[] { processKey });
    }
}
