package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;
import jp.agentec.adf.util.StringUtil;

/**
 * Created by leej on 2019/06/24.
 */

public class MOperationGroupMaster extends SQLiteTableScript {

    public MOperationGroupMaster() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE m_operation_group_master ( ");
        sql.append("        operation_group_master_id INTEGER NOT NULL ");
        sql.append("      , operation_group_master_name VARCHAR(64) NOT NULL ");
        sql.append("      , parent_operation_group_master_id INTEGER ");
        sql.append("      , operation_group_master_level INTEGER NOT NULL ");
        sql.append("      , PRIMARY KEY (operation_group_master_id) ");
        sql.append(" ) ");

        ddl.add(sql.toString());
        StringUtil.clear(sql);

        sql.append(" CREATE INDEX idx_group_master_1 ON m_operation_group_master ( ");
        sql.append("        parent_operation_group_master_id ");
        sql.append(" )  ");

        ddl.add(sql.toString());

        return ddl;
    }

    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_1_0) {
            ddl.addAll(getCreateScript(newVersion));
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
        return null;
    }
}
