package jp.agentec.adf.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * Reflectionに関する便利機能を提供します。
 * @author Taejin Hong
 * @version 1.0.0 
 */
public class ReflectionUtil {
	/**
	 * 指定したクラスのメソッドの中から、指定したキーワードから始まる名前のメソッドを取得します。
	 * @param c メソッドを取得するクラスです。
	 * @param methodPrefix 取得したいメソッドの名前のprefixです。null又は空白を指定するとフィルターリングしません。
	 * @return 条件に合致するメソッドの配列です。
	 * @since 1.0.0
	 */
	public static Method[] getMethods(Class<?> c, String methodPrefix) {
		Method[] result = new Method[]{};
		
		if (c != null) {
			Method[] allMethods = c.getMethods();
			List<Method> filteredMethods = new ArrayList<Method>();
			boolean isPrefixCheck = !StringUtil.isNullOrWhiteSpace(methodPrefix);
			
			for (Method m : allMethods) {
				if (isPrefixCheck && !m.getName().startsWith(methodPrefix)) {
					continue;
				}
				
				filteredMethods.add(m);
			}
			
			result = filteredMethods.toArray(result);
		} 
		
		return result;
	}
}
