package jp.agentec.abook.abv.bl.data.dao;

import java.util.Date;

import jp.agentec.abook.abv.bl.acms.type.LoginStatus;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.DateTimeUtil.DateUnit;
import junit.framework.TestCase;

public class MemberInfoDaoTest extends TestCase {
	
	private MemberInfoDao dao = new MemberInfoDao();
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testInsertMemberInfo() throws Exception {
		MemberInfoDto dto = new MemberInfoDto();
		dto.loginId = "test";
		dto.password = "111111";
		dto.memberName = "テスト";
		dto.sid = "123456789abc";
		dto.loginStatus = LoginStatus.LoggedIn.statusCode();
		dto.invalidPasswordCount = 0;
		dto.lastLoginDate = DateTimeUtil.getCurrentTimestamp();
		dto.lastChangePasswordDate = DateTimeUtil.getCurrentTimestamp();
		dto.lastCMSAccessDate = DateTimeUtil.getCurrentTimestamp();
		dto.passwordExpiryDate = DateTimeUtil.getCurrentTimestamp();
		dao.insertMemberInfo(dto);
	}
	
	public void testUpdateMemberInfo() throws Exception {
		MemberInfoDto dto = dao.getMemberInfo(LoginStatus.LoggedIn.statusCode());
		dto.lastCMSAccessDate = DateTimeUtil.getCurrentTimestamp();
		dao.updateMemberInfo(dto);
	}
	
	public void testSelectMemberInfo() throws Exception {
		MemberInfoDto dto = dao.getMemberInfo(LoginStatus.LoggedIn.statusCode());
		dto.lastCMSAccessDate = DateTimeUtil.add(dto.lastCMSAccessDate, DateUnit.Day, -31);
		Date current = DateTimeUtil.getCurrentTimestamp();
		
		if (current.after(DateTimeUtil.add(dto.lastCMSAccessDate, DateUnit.Day, 30))) {
			System.out.println("Force Logout");
		}
	}
}
