package com.theta.view;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;

/**
 * Adapter class for photo list display
 */
public class ImageListArrayAdapter extends ArrayAdapter<ImageRow> {
	private List<ImageRow> rows;
	private LayoutInflater inflater;
	private boolean isPhone;
	/**
	 * Constructor
	 * @param context Context
	 * @param resourceIdOfListLayout Resource ID for specifying line information
	 * @param rows Line object
     */
	public ImageListArrayAdapter(Context context, int resourceIdOfListLayout, List<ImageRow> rows, boolean isPhone) {
		super(context, resourceIdOfListLayout, rows);
		this.rows = rows;
		this.inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		this.isPhone = isPhone;
	}

    /**
     * getView Method
     * @param position Acquisition position
     * @param convertView convertView object
     * @param parent Parent object for list
     * @return View instance
     */
	@Override
	public View getView(final int position, View convertView, final ViewGroup parent) {
		ViewHolder holder;
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.listlayout_object, null);
			holder = new ViewHolder();
			holder.thumbnail = convertView.findViewById(R.id.object_thumbnail);
			holder.fileNameTextView = convertView.findViewById(R.id.tv_file_name);
			holder.creatDateTextView = convertView.findViewById(R.id.tv_create_date);
			holder.saveButton = convertView.findViewById(R.id.btn_theta_image_save);
			holder.deleteButton = convertView.findViewById(R.id.btn_theta_image_delete);
			holder.transferredTextView = convertView.findViewById(R.id.tv_transferred_status);
			convertView.setTag(holder);

			//スマートフォンの場合、サイズ調整
			if (isPhone) {
				resizeView(holder.thumbnail, 0.6f);
				resizeView(holder.saveButton, 0.7f);
				resizeView(holder.deleteButton, 0.7f);
			}
		} else {
			holder = (ViewHolder) convertView.getTag();
		}


		final ImageRow row = rows.get(position);

		if (row.isPhoto()) {
			byte[] thumbnailImage = row.getThumbnail();
			holder.thumbnail.setImageBitmap(BitmapFactory.decodeByteArray(thumbnailImage, 0, thumbnailImage.length));
		} else {
			holder.thumbnail.setImageBitmap(null);
		}

		holder.fileNameTextView.setText(row.getFileName());
		holder.creatDateTextView.setText(row.getCaptureDate());
		holder.saveButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				((ListView) parent).performItemClick(v, position, R.id.btn_theta_image_save);
			}
		});
		holder.deleteButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				((ListView) parent).performItemClick(v, position, R.id.btn_theta_image_save);
			}
		});
		if (row.isTransferred()) {
			holder.transferredTextView.setVisibility(View.VISIBLE);
		} else {
			holder.transferredTextView.setVisibility(View.INVISIBLE);
		}
		return convertView;
	}

	/**
	 * ImageView, Buttonサイズ調整
	 * @param view (ImageView, Button)
	 * @param scale サイズ調整率
	 */
	private void resizeView(View view, float scale) {
		ViewGroup.LayoutParams params = view.getLayoutParams();
		//サイズに変更
		params.width = (int) (params.width * scale);
		if (view instanceof ImageView) {
			params.height = (int) (params.height * scale);
		}
		view.setLayoutParams(params);
	}

	public void setListItem(List<ImageRow> changeRows) {
		this.rows = changeRows;
	}

	static class ViewHolder {
		Button deleteButton;
		Button saveButton;
		TextView fileNameTextView;
		TextView creatDateTextView;
		TextView transferredTextView;
		ImageView thumbnail;

	}
}
