package jp.agentec.abook.abv.cl.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

import java.util.Map;
import java.util.Objects;

import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.CommunicationLogic;
import jp.agentec.abook.abv.bl.logic.UserAuthenticateLogic;
import jp.agentec.abook.abv.cl.util.AppUtil;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVAuthenticatedActivity;
import jp.agentec.abook.abv.ui.common.activity.ShowPushMessageDailogActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.home.activity.OperationRelatedContentActivity;
import jp.agentec.abook.abv.ui.home.activity.SplashScreenActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.viewer.activity.AudioPlayActivity;
import jp.agentec.abook.abv.ui.viewer.activity.ContentViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.HTMLWebViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.ImageViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.VideoViewActivity;
import jp.agentec.adf.util.StringUtil;

public class ABVFcmListenerService extends FirebaseMessagingService {
    private static final String TAG = "ABVFcmListenerService";
    private NotificationManager mNotificationManager;
    private static int mNotificationConnect = 0;
    private CommunicationLogic communicationLogic = AbstractLogic.getLogic(CommunicationLogic.class);

    @Override
    public void onCreate() {
        super.onCreate();
        mNotificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel notificationChannel = new NotificationChannel(getApplicationContext().getPackageName(), getString(R.string.app_name), NotificationManager.IMPORTANCE_DEFAULT);

            if (mNotificationManager != null) {
                mNotificationManager.createNotificationChannel(notificationChannel);
            }
        }
    }
    @Override
    public void onNewToken(@NonNull String token) {
        Logger.i(TAG, "onNewToken token = " + token);
        PreferenceUtil.putUserPref(this, AppDefType.UserPrefKey.NEED_SEND_TOKEN, true);
    }

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map<String, String> messageMap = remoteMessage.getData();

        Logger.d(TAG,"onMessageReceived(): messageMap :"+ messageMap);
        try {
            UserAuthenticateLogic logic = AbstractLogic.getLogic(UserAuthenticateLogic.class);
            MemberInfoDto memberInfo = logic.getMemberInfo();
            boolean hasMessageBody = !StringUtil.isNullOrWhiteSpace(messageMap.get(AppDefType.PushMessageKey.message));
            boolean isPushMessageEnabled = this.getResources().getInteger(R.integer.push_message) == 1;
            if (hasMessageBody && isPushMessageEnabled && memberInfo != null) {
                // Check pushmessage by chat
                String messageBody = messageMap.get(AppDefType.PushMessageKey.message);
                String roomName = "";

                if (Objects.requireNonNull(messageBody).indexOf(AppDefType.ChatPushMessageKey.pushSendLoginId) > 0) {
                    PushMessageJSON json = new PushMessageJSON(messageBody);
                    roomName = json.getRoomName();
                    //TODO pushメッセージが到着した際、新着メッセージかルーム招待か判別してDB格納が必要
                    //Integer insertId = 0;
                    //Integer messageType = 0;
                    //insertId = json.getString("insertId");
                    //ChatMessageDto chatMessageDto = new ChatMessageDto();
                    //chatMessageDto.chatRoomId =
                    //chatRoomId shopMemberId messge messageType insertDate
                }

                if (AppUtil.isAppForground(this)) {
                    if (roomName.length() > 0) {
                        showChatRoomPopupMessage(messageMap);
                    } else {
                        String data = messageMap.get(AppDefType.PushMessageKey.data);
                        String operationID = messageMap.get(AppDefType.PushMessageKey.operationId);
                        showOperationPopUpMessage(messageBody, data, operationID);
                    }
                } else {
                    sendNotification(messageMap);
                }
            }
        } catch (ABVException e) {
            // ignore
            Logger.e(TAG, e.toString());
        } catch (JSONException e) {
            Logger.e(TAG, e.toString());
        }
    }

    /**
     * プッシュメッセージをダイアログ表示する
     * @param messageMap 受信したメッセージを格納したMapオブジェクト
     */
    private void showChatRoomPopupMessage(Map<String, String> messageMap) {
        String messageBody = messageMap.get(AppDefType.PushMessageKey.message);
        Logger.d("messageBody = " + messageBody);
        PushMessageJSON json;
        if (StringUtil.isNullOrEmpty(messageBody)) {
            return;
        }
        json = new PushMessageJSON(messageBody);

        Activity currentActivity = ActivityHandlingHelper.getInstance().getCurrentActivity();
        String baseActivityName = currentActivity.getClass().getName();
        if (currentActivity.getClass().equals(HTMLWebViewActivity.class) ||
                currentActivity.getClass().equals(ContentViewActivity.class) ||
                currentActivity.getClass().equals(OperationRelatedContentActivity.class) ||
                currentActivity.getClass().equals(OperationListActivity.class) ||
                currentActivity.getClass().equals(ImageViewActivity.class) ||
                currentActivity.getClass().equals(VideoViewActivity.class) ||
                currentActivity.getClass().equals(AudioPlayActivity.class)
        ){
            // 呼び出し元のActivityの名前をmessageMapに追加する
            messageMap.put(AppDefType.ChatPushMessageKey.baseActivityName, baseActivityName);
            messageMap.put(AppDefType.ChatPushMessageKey.needsDisplayOperationOrOperationRelatedContentScreen, "true");
            ((ABVAuthenticatedActivity)currentActivity).showChatRoomPopupMessage((Context)currentActivity, messageMap);
        } else {
            // それ以外のActivityの場合の処理
            Intent pushMsgDialog = new Intent(ABVFcmListenerService.this, ShowPushMessageDailogActivity.class);
            pushMsgDialog.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            pushMsgDialog.putExtra(AppDefType.PushMessageKey.message, json.getMessage());
            pushMsgDialog.putExtra(AppDefType.PushMessageKey.data, json.getData());
            pushMsgDialog.putExtra(AppDefType.PushMessageKey.operationId, json.getOperationID());
            pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.roomId, json.getRoomId());
            pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.roomName, json.getRoomName());
            pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.pushSendLoginId, json.getPushSendLoginId());
            pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.pushSendDate, json.getPushSendDate());
            pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.roomType, json.getRoomType());
            String collaborationType = communicationLogic.getCollaborationType(json.getMessage());
            if (collaborationType != null) {
                pushMsgDialog.putExtra(AppDefType.ChatPushMessageKey.collaborationType, collaborationType);
            }
            startActivity(pushMsgDialog);
        }
    }

    private void showOperationPopUpMessage(String textMessage, String data, String operationID) {
        Intent pushMsgDialog = new Intent(ABVFcmListenerService.this, ShowPushMessageDailogActivity.class);
        pushMsgDialog.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        pushMsgDialog.putExtra(AppDefType.PushMessageKey.message, textMessage);
        pushMsgDialog.putExtra(AppDefType.PushMessageKey.data, data);
        pushMsgDialog.putExtra(AppDefType.PushMessageKey.operationId, operationID);
        startActivity(pushMsgDialog);
    }

    /**
     * アプリがバックグラウンドなので通知エリアにアイコン表示する。
     * アイコンタップ時の情報を作成する。
     */
    private void sendNotification(Map<String, String> message) {
        Intent intent = instantiatePushNotificationIntent(message);

        Notification notification;

        if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            int uniqueId = (int) System.currentTimeMillis();
            PendingIntent pendingIntent = PendingIntent.getActivity(this, uniqueId, intent, PendingIntent.FLAG_UPDATE_CURRENT|PendingIntent.FLAG_IMMUTABLE);
            notification = getNotificationBuilder(pendingIntent, message).setChannelId(getApplicationContext().getPackageName()).build();

            if (mNotificationManager != null) {
                mNotificationManager.notify(uniqueId, notification);
            }
        } else {
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);

            Notification.Builder nb = getNotificationBuilder(pendingIntent, message);

            if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1) {
                //noinspection deprecation(API16から非推奨になった。無視)
                notification = nb.getNotification();
            } else {
                notification = nb.build();
            }

            notification.flags |= Notification.FLAG_SHOW_LIGHTS;
            notification.flags |= Notification.FLAG_AUTO_CANCEL;

            // Notification ID 증가 0~999 까지 순환
            mNotificationConnect = (mNotificationConnect + 1) % 1000;

            if (mNotificationManager != null) {
                mNotificationManager.notify(mNotificationConnect, notification);
            }
        }
    }

    Intent instantiatePushNotificationIntent(Map<String, String> message) {
        Intent intent = new Intent();
        intent.setClassName(getApplicationContext(), SplashScreenActivity.class.getName());
        // 定期点検用
        if (message.get(AppDefType.PushMessageKey.operationId) != null) {
            intent.putExtra(AppDefType.PushMessageKey.operationId, message.get(AppDefType.PushMessageKey.operationId));
            intent.putExtra(AppDefType.PushMessageKey.message, message.get(AppDefType.PushMessageKey.message));
            return intent;
        }

        // Check pushmessage by chat
        // チャットプッシュメッセージがある場合
        if (StringUtil.isNullOrWhiteSpace(message.get(AppDefType.PushMessageKey.message))) {
            return intent;
        }
        String messageBody = message.get(AppDefType.PushMessageKey.message);
        if (Objects.requireNonNull(messageBody).indexOf(AppDefType.ChatPushMessageKey.pushSendLoginId) <= 0) {
            return intent;
        }

        JSONObject json = new JSONObject(messageBody);
        String textMessage = json.getString(AppDefType.PushMessageKey.message);
        String roomType = "";

        String roomName = json.getString(AppDefType.ChatPushMessageKey.roomName);
        String pushMsg = json.getString(AppDefType.PushMessageKey.message);
        message.put(AppDefType.PushMessageKey.message, pushMsg);

        if (roomName.length() <= 0) {
            return intent;
        }

        long roomId = json.getLong(AppDefType.ChatPushMessageKey.roomId);
        long pushSendDate = json.getLong(AppDefType.ChatPushMessageKey.pushSendDate);
        String pushSendLoginId = json.getString(AppDefType.ChatPushMessageKey.pushSendLoginId);
        String collaobrationInvitedMessage = textMessage;

        intent.putExtra(AppDefType.PushMessageKey.message, collaobrationInvitedMessage);
        intent.putExtra(AppDefType.ChatPushMessageKey.roomId, roomId);
        intent.putExtra(AppDefType.ChatPushMessageKey.roomName, roomName);
        intent.putExtra(AppDefType.ChatPushMessageKey.pushSendLoginId, pushSendLoginId);
        intent.putExtra(AppDefType.ChatPushMessageKey.pushSendDate, pushSendDate);
        intent.putExtra(AppDefType.ChatPushMessageKey.roomType, roomType);
        String collaborationType = communicationLogic.getCollaborationType(textMessage);
        if (collaborationType != null) {
            intent.putExtra(AppDefType.ChatPushMessageKey.collaborationType, collaborationType);
        }

        return intent;
    }

    private Notification.Builder getNotificationBuilder(PendingIntent pendingIntent, Map<String, String> message) {
        String txtMessage = message.get(AppDefType.PushMessageKey.message);
        return new Notification.Builder(this)
                .setDefaults(Notification.DEFAULT_ALL)
                .setSmallIcon(R.drawable.icon)
                .setWhen(System.currentTimeMillis())
                .setAutoCancel(true)
                .setContentTitle(getString(R.string.app_name))
                .setContentText(txtMessage)
                .setContentIntent(pendingIntent);
    }

    private String getDownloadUrlByShareKey(String shareKey) {
        String downloadUrl = null;
        if (!StringUtil.isNullOrEmpty(shareKey)) {
            downloadUrl = "https://" + getString(R.string.repository_fqdn) + "/" + shareKey;
        }
        return downloadUrl;
    }

}
