package jp.agentec.abook.abv.launcher.android;

import jp.agentec.abook.abv.bl.common.log.Logger;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

public class ABVApplicationHelper {
	private static final String TAG = "ABVApplicationHelper";
	private static final int MAX_COUNT = 10;
	private static final int CHECK_INTERVAL = 3;

	private Context mContext;
	private volatile boolean keep;
	private int checkCount;
	
	public ABVApplicationHelper(Context context) {
		this.mContext = context;
	}

	/**
	 * 2秒後に再起動する
	 */
	public void restartApplication() {
		Logger.w(TAG, "Restart ABook Application!");
		Intent launchIntent = mContext.getPackageManager().getLaunchIntentForPackage(mContext.getPackageName());
		PendingIntent intent = PendingIntent.getActivity(mContext, 0, launchIntent, 0);
		AlarmManager mgr = (AlarmManager) mContext.getSystemService(Context.ALARM_SERVICE);
		mgr.set(AlarmManager.RTC, System.currentTimeMillis() + 2000, intent);
		android.os.Process.killProcess(android.os.Process.myPid());
	}  
}
