package jp.agentec.abook.abv.ui.home.helper;

import jp.agentec.abook.abv.bl.acms.type.DeliveryType;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContentLogic;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * ContentView関連のロジックを定義する
 * TODO:ContentViewActivity内のロジックもここに移す
 * Created by jang on 2016/03/07.
 */
public class ContentViewHelper {

    private static final String TAG = ContentViewHelper.class.getSimpleName();
    protected ContentDao contentDao = AbstractDao.getDao(ContentDao.class);
    protected static ContentLogic contentLogic = AbstractLogic.getLogic(ContentLogic.class);

    private static ContentViewHelper contentViewHelper = null;

    public static synchronized ContentViewHelper getInstance() {
        if (contentViewHelper == null) {
            contentViewHelper = new ContentViewHelper();
        }
        return contentViewHelper;
    }

    //2012 12 17 Contents link by jeonghun
    public int linkDownloadChecked(final long contentId, int page) {
        Logger.i(TAG, "linkDownloadChecked targetContentId=" + contentId + " targetPage=" + page);
        ContentDto linkContentDto = contentDao.getContent(contentId);

       if (linkContentDto == null) {
            // コンテンツが存在しない
            return LinkContentStatus.NoExist;
        } else if (DateTimeUtil.getCurrentDate().before(linkContentDto.deliveryStartDate)) {
            // 公開日前
            return LinkContentStatus.BeforeReleaseDate;
        } else if (linkContentDto.downloadedFlg) {
            // ダウンロード済み
            return LinkContentStatus.DownloadedContent;
        } else {
            // コンテンツ詳細を表示
            return LinkContentStatus.StartContentDownloadAndStart;
        }
    }

    /**
     * Panoコンテンツタイプのチェック
     * @param contentId
     * @return 0 :None 1:PanoMovie 2:PanoImage
     */
    public int check360Content(long contentId) {
        ContentDto dto = contentDao.getContent(contentId);
        int ret = 0;
        if (dto.isPanoMovie()) {
            ret = 1;
        } else if (dto.isPanoImage()) {
            ret = 2;
        }
        return ret;
    }

    // Constants
    public interface LinkContentStatus {
        int NoExist = 0;
        int BeforeReleaseDate = 1;
        int DownloadedContent = 2;
        int StreamingContent = 3;
        int StartContentDownloadAndStart = 4;
    }
}
