package jp.agentec.abook.abv.ui.viewer.view;

import jp.agentec.abook.abv.bl.common.log.Logger;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.SurfaceView;
import android.widget.LinearLayout;

public class ActionSurfaceView extends SurfaceView {
	private static final String TAG = "ActionSurfaceView";
	private int mOriginalWidth;
	private int mOriginalHeight;
	private int mOriginalTop;
	private int mOriginalLeft;
	private boolean mMaxViewFlg = false;   //最大表示フラグ false:通常, true:最大化
	
	public ActionSurfaceView(Context context) {
		super(context);
	}
	
	public void setOriginalSize(int w, int h, int top, int left) {
		mOriginalWidth = w;
		mOriginalHeight = h;
		mOriginalTop = top;
		mOriginalLeft = left;
	}
	
	public void setMaxView(boolean flg, int w, int h, int left, int top) {
		Logger.d(TAG, "setMaxView mMaxViewFlg=" + flg + " w:" + w + " h:" + h + " left:" + left);
		mMaxViewFlg = flg;
		if (mMaxViewFlg == true) {
			LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(w, h);
			params.setMargins(left, top, 0, 0);
			setLayoutParams(params);
			refreshDrawableState();
		}
	}
	
	public void doDraw(Canvas canvas) { // TODO: later　再生中の拡大をしなくなったので、不要。このメソッドが呼ばれることはない。
		if (mMaxViewFlg == false) {
			float[] matrixValue = new float[9];
			canvas.getMatrix().getValues(matrixValue);
			float matrixX = matrixValue[Matrix.MTRANS_X];
			float matrixY = matrixValue[Matrix.MTRANS_Y];
			float mscaleX = matrixValue[Matrix.MSCALE_X];
			float mscaleY = matrixValue[Matrix.MSCALE_Y];
			
			int w = (int)(mOriginalWidth * mscaleX);
			int h = (int)(mOriginalHeight * mscaleY);
			
			int left;
			int top;
//			if (Build.VERSION.SDK_INT == 15) {
//			if (Build.MODEL.equals("GT-N7000")) {
//				Logger.d(TAG, "GT-N7000");
//				left = (int)((float)(matrixX));
//				top = (int)((float)(matrixY));
//			} else {
				left = (int)((float)(matrixX - (float)mOriginalLeft));
				top = (int)((float)(matrixY - (float)mOriginalTop));
//			}
			
			LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(w, h);
			params.setMargins(left, top, 0, 0);
			setLayoutParams(params);
			
			Logger.d(TAG, "doDraw w:" + w + " h:" + h + " left:" + left + " top:" + top);
		}
	}
}
