/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.LinearLayout;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.OZImagePickerView$1;
import oz.client.shape.ui.OZImagePickerView$2;
import oz.client.shape.ui.OZImagePickerView$layoutResizeWithIDRunnable;
import oz.main.OZStorage;

public class OZImagePickerView
extends LinearLayout
implements SurfaceHolder.Callback {
    SurfaceView mSurfaceView;
    SurfaceHolder mHolder;
    Camera.Size mPreviewSize;
    Camera.Size mPictureSize;
    List mSupportedPreviewSizes;
    Camera mCamera;
    int m_width;
    int m_height;
    ICImagePickerWnd parent;
    public int rotationResult = 0;
    public float scaledChildWidth;
    public float scaledChildHeight;
    public float posLeft;
    public float posTop;
    public float flagLayout = 0.0f;
    public float pictureRatioW;
    public float pictureRatioH = 1.0f;
    public int previewWidth;
    public int previewHeight;
    public int pictureWidth;
    public int pictureHeight;
    int dpi = 96;
    private final int DEFAULT_IMAGE_SIZE = 921600;
    Camera.Parameters parameters;
    boolean isFirst = true;

    public void removeAllObject() {
        if (this.mSurfaceView != null) {
            this.removeView((View)this.mSurfaceView);
        }
        this.mSurfaceView = null;
        this.mHolder = null;
        this.mPreviewSize = null;
        this.mSupportedPreviewSizes = null;
        if (this.mCamera != null) {
            this.mCamera.release();
        }
        this.mCamera = null;
    }

    public OZImagePickerView(Context context, ICImagePickerWnd iCImagePickerWnd) {
        super(context);
        this.parent = iCImagePickerWnd;
        this.mSurfaceView = new SurfaceView(context);
        LinearLayout linearLayout = new LinearLayout(context);
        LinearLayout linearLayout2 = new LinearLayout(context);
        this.mSurfaceView.bringToFront();
        this.addView((View)linearLayout);
        this.addView((View)this.mSurfaceView);
        this.addView((View)linearLayout2);
        this.mHolder = this.mSurfaceView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mSupportedPreviewSizes = this.mCamera.getParameters().getSupportedPreviewSizes();
            Point point = OZStorage.getScreenSize(this.getContext());
            int n = Math.max(point.x, point.y);
            ArrayList<Camera.Size> arrayList = new ArrayList<Camera.Size>();
            for (int j = 0; j < this.mSupportedPreviewSizes.size(); ++j) {
                Camera.Size size = (Camera.Size)this.mSupportedPreviewSizes.get(j);
                if (n >= size.width || n >= size.height) {
                    arrayList.add(size);
                    continue;
                }
                Log.i((String)"OZViewer", (String)String.format("remove preview size(%d, %d)", size.width, size.height));
            }
            this.mSupportedPreviewSizes = arrayList;
            this.checkSupportedPictureSizeAtPreviewSize(this.mSupportedPreviewSizes, null);
            this.requestLayout();
        }
    }

    protected void onMeasure(int n, int n2) {
        if (this.parent.getCameraType() == 0) {
            int n3 = this.parent.m_w;
            int n4 = this.parent.m_h;
            this.setMeasuredDimension(n3, n4);
            if (this.mSupportedPreviewSizes != null && this.mPreviewSize == null) {
                this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes);
            }
        } else {
            super.onMeasure(n, n2);
        }
    }

    private void tryPreviewSize(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.rotationResult == 90 || this.rotationResult == 270;
        if (this.mPreviewSize != null) {
            n = this.mPreviewSize.width;
            n2 = this.mPreviewSize.height;
        }
        if (bl) {
            this.previewWidth = n2;
            this.previewHeight = n;
        } else {
            this.previewWidth = n;
            this.previewHeight = n2;
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (bl && this.getChildCount() > 0) {
            View view = this.getChildAt(1);
            float f2 = n3 - n;
            float f3 = n4 - n2;
            this.calcOrientation();
            if (this.parent.getCameraType() == 0) {
                this.tryPreviewSize((int)f2, (int)f3);
                if (f2 * (float)this.previewHeight > f3 * (float)this.previewWidth) {
                    this.scaledChildWidth = (float)this.previewWidth * f3 / (float)this.previewHeight;
                    this.scaledChildHeight = f3;
                    this.posLeft = 0.0f;
                    this.posTop = 0.0f;
                    if (this.parent.m_cLeft + this.scaledChildWidth > f2) {
                        if (this.scaledChildWidth < this.parent.m_cRight) {
                            this.posLeft = this.parent.m_cRight - this.scaledChildWidth;
                        }
                        view.layout((int)this.posLeft, (int)this.posTop, (int)(this.posLeft + this.scaledChildWidth), (int)f3);
                    } else {
                        if (this.parent.m_cRight - this.parent.m_cLeft > this.scaledChildWidth) {
                            this.posLeft = this.parent.m_cLeft + (this.parent.m_cRight - this.parent.m_cLeft - this.scaledChildWidth) / 2.0f;
                            this.getChildAt(0).layout((int)this.parent.m_cLeft, (int)this.parent.m_cTop, (int)this.posLeft, (int)this.parent.m_cBottom);
                            this.getChildAt(0).setBackgroundColor(-16777216);
                            this.getChildAt(2).layout((int)(this.posLeft + this.scaledChildWidth), (int)this.parent.m_cTop, (int)this.parent.m_cRight, (int)this.parent.m_cBottom);
                            this.getChildAt(2).setBackgroundColor(-16777216);
                        } else {
                            this.posLeft = this.parent.m_cLeft;
                        }
                        view.layout((int)this.posLeft, (int)this.posTop, (int)(this.posLeft + this.scaledChildWidth), (int)f3);
                        this.flagLayout = 1.0f;
                    }
                } else {
                    this.scaledChildWidth = f2;
                    this.scaledChildHeight = (float)this.previewHeight * f2 / (float)this.previewWidth;
                    this.posLeft = 0.0f;
                    this.posTop = 0.0f;
                    if (this.parent.m_cTop + this.scaledChildHeight > f3) {
                        if (this.scaledChildHeight < this.parent.m_cBottom) {
                            this.posTop = (int)(this.parent.m_cBottom - this.scaledChildHeight);
                        }
                        view.layout((int)this.posLeft, (int)this.posTop, (int)f2, (int)(this.posTop + this.scaledChildHeight));
                    } else {
                        if (this.parent.m_cBottom - this.parent.m_cTop > this.scaledChildHeight) {
                            this.posTop = this.parent.m_cTop + (this.parent.m_cBottom - this.parent.m_cTop - this.scaledChildHeight) / 2.0f;
                            this.getChildAt(0).layout((int)this.parent.m_cLeft, (int)this.parent.m_cTop, (int)this.parent.m_cRight, (int)this.posTop);
                            this.getChildAt(0).setBackgroundColor(-16777216);
                            this.getChildAt(2).layout((int)this.parent.m_cLeft, (int)(this.posTop + this.scaledChildHeight), (int)this.parent.m_cRight, (int)this.parent.m_cBottom);
                            this.getChildAt(2).setBackgroundColor(-16777216);
                        } else {
                            this.posTop = this.parent.m_cTop;
                        }
                        view.layout((int)this.posLeft, (int)this.posTop, (int)f2, (int)(this.posTop + this.scaledChildHeight));
                        this.flagLayout = 2.0f;
                    }
                }
            } else {
                if (this.mSupportedPreviewSizes != null && this.mPreviewSize == null) {
                    this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes);
                }
                f2 = this.parent.m_cRight - this.parent.m_cLeft;
                f3 = this.parent.m_cBottom - this.parent.m_cTop;
                this.tryPreviewSize((int)f2, (int)f3);
                if (f2 * (float)this.previewHeight > f3 * (float)this.previewWidth) {
                    this.scaledChildWidth = f2;
                    this.scaledChildHeight = (float)this.previewHeight * f2 / (float)this.previewWidth;
                } else {
                    this.scaledChildWidth = (float)this.previewWidth * f3 / (float)this.previewHeight;
                    this.scaledChildHeight = f3;
                }
                this.posLeft = (this.scaledChildWidth - f2) / 2.0f;
                this.posTop = (this.scaledChildHeight - f3) / 2.0f;
                if (this.parent.getCameraType() == 4) {
                    view.layout((int)this.parent.m_cLeft, (int)this.parent.m_cTop, (int)this.parent.m_cLeft + 1, (int)this.parent.m_cTop + 1);
                } else if (this.parent.getCameraType() == 7) {
                    int n5 = (int)(this.parent.m_cLeft - this.posLeft);
                    int n6 = (int)(this.parent.m_cTop - this.posTop);
                    int n7 = (int)((float)n5 + this.scaledChildWidth);
                    int n8 = (int)((float)n6 + this.scaledChildHeight);
                    view.layout(n5, n6, n7, n8);
                } else {
                    view.layout(0, 0, (int)this.scaledChildWidth, (int)this.scaledChildHeight);
                }
                this.setMeasuredDimension((int)this.scaledChildWidth, (int)this.scaledChildHeight);
            }
        }
    }

    public void layoutResizeWithID(boolean bl) {
        OZImagePickerView$layoutResizeWithIDRunnable oZImagePickerView$layoutResizeWithIDRunnable = new OZImagePickerView$layoutResizeWithIDRunnable(this, bl);
        if (OZStorage.isUIThread()) {
            oZImagePickerView$layoutResizeWithIDRunnable.run();
        } else {
            this.post(oZImagePickerView$layoutResizeWithIDRunnable);
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        try {
            if (this.mCamera != null) {
                this.mCamera.setPreviewDisplay(surfaceHolder);
            }
        }
        catch (IOException iOException) {
            Log.e((String)"OZViewer", (String)"IOException caused by setPreviewDisplay()", (Throwable)iOException);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        if (this.mCamera != null) {
            this.parent.stopPreview();
        }
    }

    private Camera.Size getOptimalPreviewSizeDefault(List list, int n, int n2) {
        Camera.Size size = null;
        double d2 = 0.1;
        double d3 = (double)n / (double)n2;
        if (list == null) {
            return null;
        }
        double d4 = Double.MAX_VALUE;
        int n3 = n2;
        for (Camera.Size size2 : list) {
            double d5 = (double)size2.width / (double)size2.height;
            if (Math.abs(d5 - d3) > 0.1 || !((double)Math.abs(size2.height - n3) < d4)) continue;
            size = size2;
            d4 = Math.abs(size2.height - n3);
        }
        if (size == null) {
            d4 = Double.MAX_VALUE;
            for (Camera.Size size2 : list) {
                if (!((double)Math.abs(size2.height - n3) < d4)) continue;
                size = size2;
                d4 = Math.abs(size2.height - n3);
            }
        }
        return size;
    }

    private Camera.Size getOptimalPreviewSizeDefault(List list) {
        Camera.Size size = null;
        int n = OZStorage.m_screenHeight;
        int n2 = OZStorage.m_screenWidth;
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        float f2 = (float)n2 / (float)n;
        List list2 = this.parameters == null ? this.parent.mCamera.getParameters().getSupportedPictureSizes() : this.parameters.getSupportedPictureSizes();
        float[] fArray = new float[list.size()];
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        int n4 = 0;
        int n5 = 0;
        for (int j = 0; j < list.size(); ++j) {
            fArray[n4] = (float)((Camera.Size)list.get((int)j)).width / (float)((Camera.Size)list.get((int)j)).height;
            boolean bl = false;
            for (int k = 0; k < n4; ++k) {
                if (!(Math.abs(fArray[k] - fArray[n4]) < 0.01f)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            nArray[n4] = (int)(Math.abs(f2 - fArray[n4]) < 0.2f ? (float)this.findSameRatioSize(list2, fArray[n4]).size() * 1.5f : (float)this.findSameRatioSize(list2, fArray[n4]).size());
            nArray2[n4] = j;
            if (nArray[n4] > nArray[n5]) {
                n5 = n4;
            }
            ++n4;
        }
        size = (Camera.Size)list.get(nArray2[n5]);
        return size;
    }

    private void checkSupportedPictureSizeAtPreviewSize(List list, List list2) {
        if (list2 == null) {
            list2 = this.mCamera.getParameters().getSupportedPreviewSizes();
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.05;
        boolean bl = false;
        double d5 = 1.0;
        Camera.Size size = null;
        for (int j = list.size() - 1; j >= 0; --j) {
            Camera.Size size2 = (Camera.Size)list.get(j);
            d2 = (double)size2.width / (double)size2.height;
            bl = false;
            for (int k = list2.size() - 1; k >= 0; --k) {
                int n;
                int n2;
                Camera.Size size3 = (Camera.Size)list2.get(k);
                d3 = (double)size3.width / (double)size3.height;
                double d6 = Math.abs(d2 - d3);
                if (d6 < d5) {
                    d5 = d6;
                    size = size2;
                } else if (d5 == d6 && size != null && (n2 = Math.abs(size.width * size.height - 921600)) > (n = Math.abs(size2.width * size2.height - 921600))) {
                    size = size2;
                }
                if (!(d6 < 0.05)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.remove(j);
            Log.d((String)"OZViewer", (String)("remove picture size : " + size2.width + ", " + size2.height));
        }
        if (list.size() == 0) {
            list.add(size);
        }
    }

    private Camera.Size getOptimalPreviewSize(List list) {
        if (this.parent.getCameraType() == 4) {
            return this.getOptimalPreviewSizeDefault(list, 1280, 720);
        }
        if (this.parent.getCameraType() == 7) {
            List list2 = this.bubble_sort(list, list.size());
            for (int j = list2.size() - 1; j >= 0; --j) {
                Camera.Size size = (Camera.Size)list2.get(j);
                if (size.width * size.height < 2073600) continue;
                return size;
            }
            return (Camera.Size)list2.get(0);
        }
        return this.getOptimalPreviewSizeDefault(list);
    }

    public boolean isLandscapeTop(Context context) {
        int n;
        if (OZStorage.DEVICE_CAMERA_POSITION_PRIORITY != null && (n = OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.size()) > 0) {
            for (String string : OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.keySet()) {
                if (!Build.DEVICE.equalsIgnoreCase(string) && !Build.MODEL.equalsIgnoreCase(string)) continue;
                boolean bl = OZStorage.CAMERA_POSITION_LANDSCAPE_TOP == (Integer)OZStorage.DEVICE_CAMERA_POSITION_PRIORITY.get(string);
                return bl;
            }
        }
        if (OZStorage.isDeviceIncludedInModels(new String[]{"SHW-M180", "SHW-M500", "NEXUS 7", "NEXUS 9", "SM-T330", "SM-T550", "SM-P550", "SM-P555", "SM-T700", "SM-T705"})) {
            return false;
        }
        n = (context.getResources().getConfiguration().screenLayout & 0xF) == 4 ? 1 : 0;
        boolean bl = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
        return n != 0 || bl;
    }

    private boolean isSupportPictureSize(Camera.Size size) {
        PointF pointF = this.calcSupportPictureSizeToDPI(size);
        return pointF.x >= (float)this.dpi && pointF.y >= (float)this.dpi;
    }

    private List findSameRatioSize(List list, Camera.Size size) {
        return this.findSameRatioSize(list, (float)size.width / (float)size.height);
    }

    private List findSameRatioSize(List list, float f2) {
        ArrayList arrayList = new ArrayList();
        for (int j = 0; j < list.size(); ++j) {
            if (!(Math.abs(f2 - (float)((Camera.Size)list.get((int)j)).width / (float)((Camera.Size)list.get((int)j)).height) < 0.01f)) continue;
            arrayList.add(list.get(j));
        }
        return arrayList;
    }

    private PointF calcSupportPictureSizeToDPI(Camera.Size size) {
        Rect rect = new Rect();
        if (this.parent.getCameraType() == 99 || this.parent.getCameraType() == 4 || this.parent.getCameraType() == 7) {
            this.parent.computeCenterSize();
            Log.e((String)"OZViewer", (String)"calcSupportPictureSize NOT_YET(ICImagePickerWnd.CAMERA_STYLE_CENTER, ICImagePickerWnd.CAMERA_STYLE_SEAL, ICImagePickerWnd.CAMERA_STYLE_ID)");
        } else {
            rect.set(this.parent.computeAllSize(size, this.mPreviewSize));
        }
        return new PointF((float)rect.width() / (this.parent.m_sWidth / 72.0f), (float)rect.height() / (this.parent.m_sHeight / 72.0f));
    }

    private Camera.Size getSupportPictureSize(List list, Camera.Size size) {
        List list2 = this.findSameRatioSize(list, size);
        Camera.Size size2 = null;
        if (list2.size() == 0) {
            for (int j = list.size() - 1; j >= 0; --j) {
                if (!this.isSupportPictureSize((Camera.Size)list.get(j))) continue;
                size2 = (Camera.Size)list.get(j);
                break;
            }
        } else {
            for (int j = list2.size() - 1; j >= 0; --j) {
                if (!this.isSupportPictureSize((Camera.Size)list2.get(j))) continue;
                size2 = (Camera.Size)list2.get(j);
                break;
            }
            if (size2 == null) {
                float f2 = Float.MAX_VALUE;
                int n = -1;
                for (int j = 0; j < list2.size(); ++j) {
                    PointF pointF = this.calcSupportPictureSizeToDPI((Camera.Size)list2.get(j));
                    float f3 = pointF.x - (float)this.dpi;
                    float f4 = pointF.y - (float)this.dpi;
                    float f5 = f3 * f3 + f4 * f4;
                    if (!(f5 < f2)) continue;
                    n = j;
                    f2 = f5;
                }
                size2 = (Camera.Size)list2.get(n);
            }
        }
        return size2;
    }

    private List getIDSealPreviewSize() {
        if (this.mPreviewSize != null) {
            ArrayList<Camera.Size> arrayList = new ArrayList<Camera.Size>();
            arrayList.add(this.mPreviewSize);
            return arrayList;
        }
        return null;
    }

    private void calcOrientation() {
        int n = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        int n3 = 0;
        if (this.parent.mCameraInfo != null) {
            n3 = this.parent.mCameraInfo.orientation;
        } else if (!this.isLandscapeTop(this.getContext())) {
            n3 = 90;
        }
        if (this.parent.mCameraInfo != null && this.parent.mCameraInfo.facing == 1) {
            this.rotationResult = (n3 + n2) % 360;
            this.rotationResult = (360 - this.rotationResult) % 360;
        } else {
            this.rotationResult = (n3 - n2 + 360) % 360;
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (this.mCamera != null) {
            this.parameters = this.mCamera.getParameters();
            this.calcOrientation();
            this.mCamera.setDisplayOrientation(this.rotationResult);
            if (this.mPreviewSize == null) {
                this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes);
            }
            boolean bl = this.parent.getCameraType() != 4 && this.parent.getCameraType() != 7;
            Camera.Size size = null;
            List list = this.mCamera.getParameters().getSupportedPictureSizes();
            this.checkSupportedPictureSizeAtPreviewSize(list, bl ? null : this.getIDSealPreviewSize());
            if (list.size() == 0) {
                list = this.mCamera.getParameters().getSupportedPictureSizes();
            }
            if (list.size() > 1) {
                list = this.bubble_sort(list, list.size());
            }
            if (!bl) {
                int n4 = 921600;
                for (int j = list.size() - 1; j >= 0; --j) {
                    int n5 = ((Camera.Size)list.get((int)j)).width;
                    int n6 = ((Camera.Size)list.get((int)j)).height;
                    if (n5 * n6 < n4) continue;
                    size = (Camera.Size)list.get(j);
                    break;
                }
                if (size == null) {
                    size = (Camera.Size)list.get(0);
                }
            } else {
                this.dpi = this.parent.m_dpi;
                size = this.getSupportPictureSize(list, this.mPreviewSize);
                if (size == null) {
                    size = (Camera.Size)list.get(0);
                }
            }
            this.mPictureSize = size;
            this.parameters.setPictureSize(this.mPictureSize.width, this.mPictureSize.height);
            this.parameters.setPreviewSize(this.mPreviewSize.width, this.mPreviewSize.height);
            String string = this.findSettableValue(this.parameters.getSupportedFocusModes(), "auto");
            if (string != null) {
                this.parameters.setFocusMode(string);
            }
            if (this.isFirst) {
                this.parent.setOZButtonOnClickListener(this.parent.OZImagePickerFlashButton, new OZImagePickerView$1(this));
                this.parent.setOZButtonOnClickListener(this.parent.OZImagePickerFacingButton, new OZImagePickerView$2(this));
                this.isFirst = false;
            }
            this.parent.getOZButtonFromResouce(this.parent.OZImagePickerFacingButton, null, this.parent.getFacingBGDefaultPath(), null, false);
            this.doSetTorch(this.parameters, this.parent.m_flashMode);
            Log.d((String)"OZViewer", (String)("selectPreviewSize(" + this.mPreviewSize.width + "," + this.mPreviewSize.height + ") selectPictureSize(" + size.width + "," + size.height + ")"));
            this.requestLayout();
            this.pictureWidth = size.width;
            this.pictureHeight = size.height;
            this.pictureRatioW = (float)size.width / (float)this.mPreviewSize.width;
            this.pictureRatioH = (float)size.height / (float)this.mPreviewSize.height;
            this.setRecordingHint();
            this.mCamera.setParameters(this.parameters);
            if (this.parent.OZButton1 != null && this.parent.OZButton1.getAction() == 1) {
                if ("shutter".equals(this.parent.OZButton1.getContentDescription())) {
                    this.parent.startCameraPreview();
                }
            } else if (this.parent.OZButton2 != null && this.parent.OZButton2.getAction() == 1) {
                if ("shutter".equals(this.parent.OZButton2.getContentDescription())) {
                    this.parent.startCameraPreview();
                }
            } else {
                this.parent.startCameraPreview();
            }
        }
    }

    private void setRecordingHint() {
        if (Build.VERSION.SDK_INT >= 14 && (this.parent.getCameraType() == 99 || this.parent.getCameraType() == 4 || this.parent.getCameraType() == 7) && this.parameters != null) {
            try {
                Method method = this.parameters.getClass().getMethod("setRecordingHint", Boolean.TYPE);
                method.invoke((Object)this.parameters, true);
                System.out.println("Camera parameter : setRecordingHint(true);");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void doSetTorch(Camera.Parameters parameters, int n) {
        String string = null;
        switch (n) {
            case 0: {
                if (!this.parent.supportFlashModeOff) break;
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "off");
                break;
            }
            case 1: {
                if (!this.parent.supportFlashModeOn) break;
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "on");
                break;
            }
            case 2: {
                if (!this.parent.supportFlashModeAuto) break;
                string = this.findSettableValue(parameters.getSupportedFlashModes(), "auto");
            }
        }
        if (string != null) {
            parameters.setFlashMode(string);
        }
    }

    private String findSettableValue(Collection collection, String ... stringArray) {
        Log.i((String)"OZViewer", (String)("Supported values: " + collection));
        String string = null;
        if (collection != null) {
            for (String string2 : stringArray) {
                if (!collection.contains(string2)) continue;
                string = string2;
                break;
            }
        }
        Log.i((String)"OZViewer", (String)("Settable value: " + string));
        return string;
    }

    private boolean minSize(Camera.Size size, Camera.Size size2) {
        if (size.width < size2.width) {
            return true;
        }
        if (size.width == size2.width) {
            return size.height < size2.height;
        }
        return false;
    }

    private List bubble_sort(List list, int n) {
        for (int j = 0; j < n; ++j) {
            for (int k = 1; k < n - j; ++k) {
                if (!this.minSize((Camera.Size)list.get(k - 1), (Camera.Size)list.get(k))) continue;
                Camera.Size size = (Camera.Size)list.get(k - 1);
                list.set(k - 1, list.get(k));
                list.set(k, size);
            }
        }
        return list;
    }

    static /* synthetic */ void access$000(OZImagePickerView oZImagePickerView, Camera.Parameters parameters, int n) {
        oZImagePickerView.doSetTorch(parameters, n);
    }
}

