/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.OZSignPadBackgroundView;
import oz.client.shape.ui.OZSignView;

public class OZSignPadWndBase
extends FrameLayout {
    private ICSignPadWnd mParent;
    private OZSignView mSignView;
    private PointF mTargetSize;
    private RelativeLayout mSignLayout;
    private RelativeLayout mSignBorderLayout;
    private OZSignPadBackgroundView mBackgroundView;
    private PointF mSignPadScaledSize;
    private PointF mSignPadOriginalSize;

    public OZSignPadWndBase(Context context, ICSignPadWnd iCSignPadWnd, float f2, float f3, float f4, float f5, boolean bl) {
        super(context);
        this.mParent = iCSignPadWnd;
        this.mSignPadOriginalSize = new PointF(f4, f5);
        this.mSignPadScaledSize = new PointF(f2, f3);
        this.mTargetSize = new PointF();
        this.mSignLayout = new RelativeLayout(this.getContext());
        this.mSignBorderLayout = new RelativeLayout(this.getContext());
        this.initTargetSize(this.mTargetSize);
        this.addView((View)this.getDefaultSignOverLapView(bl), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mBackgroundView = new OZSignPadBackgroundView(this.getContext(), this.getICParent());
        this.initBackgroundView(this.mBackgroundView);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        this.addBackgroundView(frameLayout, this.mBackgroundView);
        this.getSignBorderLayout().addView((View)frameLayout);
        frameLayout = new FrameLayout(this.getContext());
        this.setSignView(this.createSignView());
        this.addSignView(frameLayout, this.getSignView());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(15);
        this.getSignLayout().addView((View)frameLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    public ICSignPadWnd getICParent() {
        return this.mParent;
    }

    public void setSignView(OZSignView oZSignView) {
        this.mSignView = oZSignView;
    }

    public OZSignView getSignView() {
        return this.mSignView;
    }

    public RelativeLayout getSignBorderLayout() {
        return this.mSignBorderLayout;
    }

    public RelativeLayout getSignLayout() {
        return this.mSignLayout;
    }

    public OZSignPadBackgroundView getBackgroundView() {
        return this.mBackgroundView;
    }

    public PointF getTargetSize() {
        return this.mTargetSize;
    }

    public PointF getOriginalSize() {
        return this.mSignPadOriginalSize;
    }

    public PointF getScaledSize() {
        return this.mSignPadScaledSize;
    }

    protected void initTargetSize(PointF pointF) {
        float f2 = this.mSignPadOriginalSize.x;
        float f3 = this.mSignPadOriginalSize.y;
        if (f2 > 0.0f && f3 > 0.0f) {
            float f4 = this.mSignPadScaledSize.x;
            float f5 = f4 / f2;
            float f6 = this.mSignPadScaledSize.y;
            float f7 = f6 / f3;
            if (f5 != f7) {
                if (f5 > f7) {
                    f4 = f6 * f2 / f3;
                } else {
                    f6 = f4 * f3 / f2;
                }
            }
            pointF.set(f4, f6);
        }
    }

    protected int calcBackgroundViewWidth() {
        return -1;
    }

    protected int calcBackGroundViewHeight() {
        return -1;
    }

    protected void initBackgroundView(OZSignPadBackgroundView oZSignPadBackgroundView) {
        oZSignPadBackgroundView.setAnimations(true);
    }

    protected void addBackgroundView(FrameLayout frameLayout, OZSignPadBackgroundView oZSignPadBackgroundView) {
        frameLayout.addView((View)oZSignPadBackgroundView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.calcBackgroundViewWidth(), this.calcBackGroundViewHeight());
        layoutParams.addRule(15);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected OZSignView createSignView() {
        return new OZSignView(this.getContext(), this.getICParent(), this.getOriginalSize().x, this.getOriginalSize().y, this.getTargetSize().x, this.getTargetSize().y);
    }

    protected void addSignView(FrameLayout frameLayout, OZSignView oZSignView) {
        frameLayout.addView((View)oZSignView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
    }

    protected RectF getTargetRect() {
        return this.getICParent().getCompRect();
    }

    protected void initSignLayout(RelativeLayout relativeLayout) {
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(Math.round(this.getTargetRect().width()), Math.round(this.getTargetRect().height()), Math.round(this.getTargetRect().left), Math.round(this.getTargetRect().top)));
    }

    protected void initSignBorderLayout(RelativeLayout relativeLayout) {
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(Math.round(this.getTargetRect().width() + 8.0f), Math.round(this.getTargetRect().height() + 8.0f), Math.round(this.getTargetRect().left - 4.0f), Math.round(this.getTargetRect().top - 4.0f)));
    }

    protected void initBaseLayout(FrameLayout frameLayout) {
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected void addOtherLayout(FrameLayout frameLayout) {
    }

    protected FrameLayout getDefaultSignOverLapView(boolean bl) {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        this.initBaseLayout(frameLayout);
        this.initSignLayout(this.getSignLayout());
        this.initSignBorderLayout(this.getSignBorderLayout());
        AbsoluteLayout absoluteLayout = new AbsoluteLayout(this.getContext());
        absoluteLayout.addView((View)this.getSignLayout());
        absoluteLayout.addView((View)this.getSignBorderLayout());
        if (bl) {
            this.addOtherLayout(frameLayout);
        }
        frameLayout.addView((View)absoluteLayout);
        return frameLayout;
    }
}

