/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.data;

import android.graphics.Color;
import org.json.JSONObject;
import oz.client.shape.ui.data.OZCustomUIData;

public class OZSignPadGuideLineData
extends OZCustomUIData {
    public static final String JSON_PREFIX = "guideline";
    public static final String JSON_TARGET = "signpad";
    public static final String JSON_THICK = "thickness";
    public static final String JSON_COLOR = "color";
    public static final String JSON_ALPHA = "transparency";
    public static final String JSON_LINETYPE = "style";
    public static final String JSON_SHAPETYPE = "shape";
    private static final String[] LINETYPE_STRING = new String[]{"solid", "dashed"};
    public static final int LINETYPE_SOLID = 0;
    public static final int LINETYPE_DASH = 1;
    public static final int LINETYPE_DEFAULT = 1;
    private static final String[] SHAPETYPE_STRING = new String[]{"none", null, "underline"};
    public static final int SHAPETYPE_NONE = 0;
    public static final int SHAPETYPE_DEFAULT = 1;
    public static final int SHAPETYPE_UNDERLINE = 2;
    public static final int SHAPETYPE_RECT = 3;
    private float mThickness;
    private int mLineType;
    private int mShapeType;
    private int mColor;

    public OZSignPadGuideLineData(String string) {
        super(string);
    }

    protected String getJSONPrefix() {
        return JSON_PREFIX;
    }

    protected void init() {
        this.setThickness(5.0f);
        this.setLineType(1);
        this.setShapeType(1);
        this.setColor(Color.argb((int)128, (int)192, (int)192, (int)192));
    }

    protected JSONObject getTargetObject(JSONObject jSONObject) {
        return OZSignPadGuideLineData.getJSONObjectSafe(jSONObject, JSON_TARGET);
    }

    protected void parseInternal(JSONObject jSONObject) {
        if (this.hasJSONKey(jSONObject, JSON_THICK)) {
            this.setThickness(this.parseFloatRange(jSONObject, JSON_THICK, 5.0f, 2.1474836E9f, 0));
        }
        if (this.hasJSONKey(jSONObject, JSON_LINETYPE)) {
            this.setLineType(this.parseString(jSONObject, JSON_LINETYPE));
        }
        if (this.hasJSONKey(jSONObject, JSON_SHAPETYPE)) {
            this.setShapeType(this.parseString(jSONObject, JSON_SHAPETYPE));
        }
        this.setColor(this.parseColor(jSONObject, JSON_COLOR, JSON_ALPHA, Color.rgb((int)192, (int)192, (int)192), 128));
    }

    protected boolean validCheck() {
        boolean bl = true;
        if (this.mThickness <= 0.0f || this.mLineType < 0 || this.mLineType >= LINETYPE_STRING.length || this.mShapeType < 0 || this.mShapeType >= SHAPETYPE_STRING.length) {
            bl = false;
        }
        return bl;
    }

    public float getThickness() {
        return this.mThickness;
    }

    public void setThickness(float f2) {
        this.mThickness = f2;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public void setLineType(String string) {
        int n = 1;
        if (string != null && !string.isEmpty()) {
            for (int j = 0; j < LINETYPE_STRING.length; ++j) {
                if (!LINETYPE_STRING[j].equalsIgnoreCase(string)) continue;
                n = j;
                break;
            }
        }
        this.setLineType(n);
    }

    public void setLineType(int n) {
        this.mLineType = n;
    }

    public void setShapeType(String string) {
        int n = 1;
        if (string != null && !string.isEmpty()) {
            for (int j = 0; j < SHAPETYPE_STRING.length; ++j) {
                if (SHAPETYPE_STRING[j] == null || !SHAPETYPE_STRING[j].equalsIgnoreCase(string)) continue;
                n = j;
                break;
            }
        }
        this.setShapeType(n);
    }

    public int getShapeType() {
        return this.mShapeType;
    }

    public void setShapeType(int n) {
        this.mShapeType = n;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int n, int n2) {
        this.setColor(Color.argb((int)n, (int)Color.red((int)n2), (int)Color.green((int)n2), (int)Color.blue((int)n2)));
    }

    public void setColor(int n) {
        this.mColor = n;
    }
}

