/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.LongSparseArray;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.content.BaseStrokeContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.content.GradientColor;
import oz.lottie.model.content.GradientStroke;
import oz.lottie.model.content.GradientType;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.value.LottieValueCallback;

public class GradientStrokeContent
extends BaseStrokeContent {
    private static final int CACHE_STEPS_MS = 32;
    private final String name;
    private final boolean hidden;
    private final LongSparseArray linearGradientCache = new LongSparseArray();
    private final LongSparseArray radialGradientCache = new LongSparseArray();
    private final RectF boundsRect = new RectF();
    private final GradientType type;
    private final int cacheSteps;
    private final BaseKeyframeAnimation colorAnimation;
    private final BaseKeyframeAnimation startPointAnimation;
    private final BaseKeyframeAnimation endPointAnimation;
    private ValueCallbackKeyframeAnimation colorCallbackAnimation;

    public GradientStrokeContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, GradientStroke gradientStroke) {
        super(lottieDrawable, baseLayer, gradientStroke.getCapType().toPaintCap(), gradientStroke.getJoinType().toPaintJoin(), gradientStroke.getMiterLimit(), gradientStroke.getOpacity(), gradientStroke.getWidth(), gradientStroke.getLineDashPattern(), gradientStroke.getDashOffset());
        this.name = gradientStroke.getName();
        this.type = gradientStroke.getGradientType();
        this.hidden = gradientStroke.isHidden();
        this.cacheSteps = (int)(lottieDrawable.getComposition().getDuration() / 32.0f);
        this.colorAnimation = gradientStroke.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.colorAnimation);
        this.startPointAnimation = gradientStroke.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = gradientStroke.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        baseLayer.addAnimation(this.endPointAnimation);
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        if (this.hidden) {
            return;
        }
        this.getBounds(this.boundsRect, matrix, false);
        Object object = this.type == GradientType.LINEAR ? this.getLinearGradient() : this.getRadialGradient();
        object.setLocalMatrix(matrix);
        this.paint.setShader((Shader)object);
        super.draw(canvas, matrix, n);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private LinearGradient getLinearGradient() {
        int n = this.getGradientHash();
        LinearGradient linearGradient = (LinearGradient)this.linearGradientCache.get((long)n);
        if (linearGradient != null) {
            return linearGradient;
        }
        PointF pointF = (PointF)this.startPointAnimation.getValue();
        PointF pointF2 = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] nArray = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] fArray = gradientColor.getPositions();
        float f2 = pointF.x;
        float f3 = pointF.y;
        float f4 = pointF2.x;
        float f5 = pointF2.y;
        linearGradient = new LinearGradient(f2, f3, f4, f5, nArray, fArray, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)n, (Object)linearGradient);
        return linearGradient;
    }

    private RadialGradient getRadialGradient() {
        int n = this.getGradientHash();
        RadialGradient radialGradient = (RadialGradient)this.radialGradientCache.get((long)n);
        if (radialGradient != null) {
            return radialGradient;
        }
        PointF pointF = (PointF)this.startPointAnimation.getValue();
        PointF pointF2 = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] nArray = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] fArray = gradientColor.getPositions();
        float f2 = pointF.x;
        float f3 = pointF.y;
        float f4 = pointF2.x;
        float f5 = pointF2.y;
        float f6 = (float)Math.hypot(f4 - f2, f5 - f3);
        radialGradient = new RadialGradient(f2, f3, f6, nArray, fArray, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)n, (Object)radialGradient);
        return radialGradient;
    }

    private int getGradientHash() {
        int n = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int n2 = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int n3 = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int n4 = 17;
        if (n != 0) {
            n4 = n4 * 31 * n;
        }
        if (n2 != 0) {
            n4 = n4 * 31 * n2;
        }
        if (n3 != 0) {
            n4 = n4 * 31 * n3;
        }
        return n4;
    }

    private int[] applyDynamicColorsIfNeeded(int[] nArray) {
        block4: {
            if (this.colorCallbackAnimation == null) break block4;
            Integer[] integerArray = (Integer[])this.colorCallbackAnimation.getValue();
            if (nArray.length == integerArray.length) {
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = integerArray[n];
                    ++n;
                }
            } else {
                nArray = new int[integerArray.length];
                int n = 0;
                while (n < integerArray.length) {
                    nArray[n] = integerArray[n];
                    ++n;
                }
            }
        }
        return nArray;
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        super.addValueCallback(object, lottieValueCallback);
        if (object == LottieProperty.GRADIENT_COLOR) {
            if (lottieValueCallback == null) {
                if (this.colorCallbackAnimation != null) {
                    this.layer.removeAnimation(this.colorCallbackAnimation);
                }
                this.colorCallbackAnimation = null;
            } else {
                this.colorCallbackAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorCallbackAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorCallbackAnimation);
            }
        }
    }
}

