/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Path;
import java.util.List;
import oz.lottie.LottieDrawable;
import oz.lottie.animation.content.CompoundTrimPathContent;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.model.content.ShapePath;
import oz.lottie.model.content.ShapeTrimPath$Type;
import oz.lottie.model.layer.BaseLayer;

public class ShapeContent
implements PathContent,
BaseKeyframeAnimation$AnimationListener {
    private final Path path = new Path();
    private final String name;
    private final boolean hidden;
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation shapeAnimation;
    private boolean isPathValid;
    private CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();

    public ShapeContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, ShapePath shapePath) {
        this.name = shapePath.getName();
        this.hidden = shapePath.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.shapeAnimation = shapePath.getShapePath().createAnimation();
        baseLayer.addAnimation(this.shapeAnimation);
        this.shapeAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < list.size()) {
            Content content = (Content)list.get(n);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath$Type.SIMULTANEOUSLY) {
                TrimPathContent trimPathContent = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPathContent);
                trimPathContent.addListener(this);
            }
            ++n;
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        if (this.hidden) {
            this.isPathValid = true;
            return this.path;
        }
        this.path.set((Path)this.shapeAnimation.getValue());
        this.path.setFillType(Path.FillType.EVEN_ODD);
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

