/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.ByteString;

public final class Options
extends AbstractList
implements RandomAccess {
    final ByteString[] byteStrings;
    final int[] trie;

    private Options(ByteString[] byteStringArray, int[] nArray) {
        this.byteStrings = byteStringArray;
        this.trie = nArray;
    }

    public static Options of(ByteString ... byteStringArray) {
        int n;
        if (byteStringArray.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            return new Options(new ByteString[0], nArray);
        }
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(Arrays.asList(byteStringArray));
        Collections.sort(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            arrayList2.add(-1);
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            int n3 = Collections.binarySearch(arrayList, byteStringArray[n2]);
            arrayList2.set(n3, n2);
            ++n2;
        }
        if (((ByteString)arrayList.get(0)).size() == 0) {
            throw new IllegalArgumentException("the empty byte string is not a supported option");
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            ByteString byteString = (ByteString)arrayList.get(n2);
            n = n2 + 1;
            while (n < arrayList.size()) {
                ByteString byteString2 = (ByteString)arrayList.get(n);
                if (!byteString2.startsWith(byteString)) break;
                if (byteString2.size() == byteString.size()) {
                    throw new IllegalArgumentException("duplicate option: " + byteString2);
                }
                if ((Integer)arrayList2.get(n) > (Integer)arrayList2.get(n2)) {
                    arrayList.remove(n);
                    arrayList2.remove(n);
                    continue;
                }
                ++n;
            }
            ++n2;
        }
        Buffer buffer = new Buffer();
        Options.buildTrieRecursive(0L, buffer, 0, arrayList, 0, arrayList.size(), arrayList2);
        int[] nArray = new int[Options.intCount(buffer)];
        n = 0;
        while (n < nArray.length) {
            nArray[n] = buffer.readInt();
            ++n;
        }
        if (!buffer.exhausted()) {
            throw new AssertionError();
        }
        return new Options((ByteString[])byteStringArray.clone(), nArray);
    }

    private static void buildTrieRecursive(long l, Buffer buffer, int n, List list, int n2, int n3, List list2) {
        if (n2 >= n3) {
            throw new AssertionError();
        }
        int n4 = n2;
        while (n4 < n3) {
            if (((ByteString)list.get(n4)).size() < n) {
                throw new AssertionError();
            }
            ++n4;
        }
        ByteString byteString = (ByteString)list.get(n2);
        ByteString byteString2 = (ByteString)list.get(n3 - 1);
        int n5 = -1;
        if (n == byteString.size()) {
            n5 = (Integer)list2.get(n2);
            byteString = (ByteString)list.get(++n2);
        }
        if (byteString.getByte(n) != byteString2.getByte(n)) {
            int n6;
            int n7 = 1;
            int n8 = n2 + 1;
            while (n8 < n3) {
                if (((ByteString)list.get(n8 - 1)).getByte(n) != ((ByteString)list.get(n8)).getByte(n)) {
                    ++n7;
                }
                ++n8;
            }
            long l2 = l + (long)Options.intCount(buffer) + 2L + (long)(n7 * 2);
            buffer.writeInt(n7);
            buffer.writeInt(n5);
            int n9 = n2;
            while (n9 < n3) {
                n6 = ((ByteString)list.get(n9)).getByte(n);
                if (n9 == n2 || n6 != ((ByteString)list.get(n9 - 1)).getByte(n)) {
                    buffer.writeInt(n6 & 0xFF);
                }
                ++n9;
            }
            Buffer buffer2 = new Buffer();
            n6 = n2;
            while (n6 < n3) {
                byte by = ((ByteString)list.get(n6)).getByte(n);
                int n10 = n3;
                int n11 = n6 + 1;
                while (n11 < n3) {
                    if (by != ((ByteString)list.get(n11)).getByte(n)) {
                        n10 = n11;
                        break;
                    }
                    ++n11;
                }
                if (n6 + 1 == n10 && n + 1 == ((ByteString)list.get(n6)).size()) {
                    buffer.writeInt((Integer)list2.get(n6));
                } else {
                    buffer.writeInt((int)(-1L * (l2 + (long)Options.intCount(buffer2))));
                    Options.buildTrieRecursive(l2, buffer2, n + 1, list, n6, n10, list2);
                }
                n6 = n10;
            }
            buffer.write(buffer2, buffer2.size());
        } else {
            int n12 = 0;
            int n13 = n;
            int n14 = Math.min(byteString.size(), byteString2.size());
            while (n13 < n14) {
                if (byteString.getByte(n13) != byteString2.getByte(n13)) break;
                ++n12;
                ++n13;
            }
            long l3 = l + (long)Options.intCount(buffer) + 2L + (long)n12 + 1L;
            buffer.writeInt(-n12);
            buffer.writeInt(n5);
            int n15 = n;
            while (n15 < n + n12) {
                buffer.writeInt(byteString.getByte(n15) & 0xFF);
                ++n15;
            }
            if (n2 + 1 == n3) {
                if (n + n12 != ((ByteString)list.get(n2)).size()) {
                    throw new AssertionError();
                }
                buffer.writeInt((Integer)list2.get(n2));
            } else {
                Buffer buffer3 = new Buffer();
                buffer.writeInt((int)(-1L * (l3 + (long)Options.intCount(buffer3))));
                Options.buildTrieRecursive(l3, buffer3, n + n12, list, n2, n3, list2);
                buffer.write(buffer3, buffer3.size());
            }
        }
    }

    @Override
    public ByteString get(int n) {
        return this.byteStrings[n];
    }

    @Override
    public final int size() {
        return this.byteStrings.length;
    }

    private static int intCount(Buffer buffer) {
        return (int)(buffer.size() / 4L);
    }
}

