/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.manager;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import oz.lottie.FontAssetDelegate;
import oz.lottie.model.MutablePair;
import oz.lottie.utils.Logger;

public class FontAssetManager {
    private final MutablePair tempPair = new MutablePair();
    private final Map fontMap = new HashMap();
    private final Map fontFamilies = new HashMap();
    private final AssetManager assetManager;
    private FontAssetDelegate delegate;
    private String defaultFontFileExtension = ".ttf";

    public FontAssetManager(Drawable.Callback callback, FontAssetDelegate fontAssetDelegate) {
        this.delegate = fontAssetDelegate;
        if (!(callback instanceof View)) {
            Logger.warning("LottieDrawable must be inside of a view for images to work.");
            this.assetManager = null;
            return;
        }
        this.assetManager = ((View)callback).getContext().getAssets();
    }

    public void setDelegate(FontAssetDelegate fontAssetDelegate) {
        this.delegate = fontAssetDelegate;
    }

    public void setDefaultFontFileExtension(String string) {
        this.defaultFontFileExtension = string;
    }

    public Typeface getTypeface(String string, String string2) {
        this.tempPair.set(string, string2);
        Typeface typeface = (Typeface)this.fontMap.get(this.tempPair);
        if (typeface != null) {
            return typeface;
        }
        Typeface typeface2 = this.getFontFamily(string);
        typeface = this.typefaceForStyle(typeface2, string2);
        this.fontMap.put(this.tempPair, typeface);
        return typeface;
    }

    private Typeface getFontFamily(String string) {
        String string2;
        Typeface typeface = (Typeface)this.fontFamilies.get(string);
        if (typeface != null) {
            return typeface;
        }
        Typeface typeface2 = null;
        if (this.delegate != null) {
            typeface2 = this.delegate.fetchFont(string);
        }
        if (this.delegate != null && typeface2 == null && (string2 = this.delegate.getFontPath(string)) != null) {
            typeface2 = Typeface.createFromAsset((AssetManager)this.assetManager, (String)string2);
        }
        if (typeface2 == null) {
            string2 = "fonts/" + string + this.defaultFontFileExtension;
            typeface2 = Typeface.createFromAsset((AssetManager)this.assetManager, (String)string2);
        }
        this.fontFamilies.put(string, typeface2);
        return typeface2;
    }

    private Typeface typefaceForStyle(Typeface typeface, String string) {
        int n = 0;
        boolean bl = string.contains("Italic");
        boolean bl2 = string.contains("Bold");
        if (bl && bl2) {
            n = 3;
        } else if (bl) {
            n = 2;
        } else if (bl2) {
            n = 1;
        }
        if (typeface.getStyle() == n) {
            return typeface;
        }
        return Typeface.create((Typeface)typeface, (int)n);
    }
}

