/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.model.content.GradientColor;
import oz.lottie.parser.ValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Token;
import oz.lottie.utils.MiscUtils;

public class GradientColorParser
implements ValueParser {
    private int colorPoints;

    public GradientColorParser(int n) {
        this.colorPoints = n;
    }

    @Override
    public GradientColor parse(JsonReader jsonReader, float f2) {
        boolean bl;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        boolean bl2 = bl = jsonReader.peek() == JsonReader$Token.BEGIN_ARRAY;
        if (bl) {
            jsonReader.beginArray();
        }
        while (jsonReader.hasNext()) {
            arrayList.add(Float.valueOf((float)jsonReader.nextDouble()));
        }
        if (bl) {
            jsonReader.endArray();
        }
        if (this.colorPoints == -1) {
            this.colorPoints = arrayList.size() / 4;
        }
        float[] fArray = new float[this.colorPoints];
        int[] nArray = new int[this.colorPoints];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.colorPoints * 4) {
            int n4 = n3 / 4;
            double d2 = ((Float)arrayList.get(n3)).floatValue();
            switch (n3 % 4) {
                case 0: {
                    fArray[n4] = (float)d2;
                    break;
                }
                case 1: {
                    n = (int)(d2 * 255.0);
                    break;
                }
                case 2: {
                    n2 = (int)(d2 * 255.0);
                    break;
                }
                case 3: {
                    int n5 = (int)(d2 * 255.0);
                    nArray[n4] = Color.argb((int)255, (int)n, (int)n2, (int)n5);
                }
            }
            ++n3;
        }
        GradientColor gradientColor = new GradientColor(fArray, nArray);
        this.addOpacityStopsToGradientIfNeeded(gradientColor, arrayList);
        return gradientColor;
    }

    private void addOpacityStopsToGradientIfNeeded(GradientColor gradientColor, List list) {
        int n = this.colorPoints * 4;
        if (list.size() <= n) {
            return;
        }
        int n2 = (list.size() - n) / 2;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = n;
        int n4 = 0;
        while (n3 < list.size()) {
            if (n3 % 2 == 0) {
                dArray[n4] = ((Float)list.get(n3)).floatValue();
            } else {
                dArray2[n4] = ((Float)list.get(n3)).floatValue();
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < gradientColor.getSize()) {
            n4 = gradientColor.getColors()[n3];
            gradientColor.getColors()[n3] = n4 = Color.argb((int)this.getOpacityAtPosition(gradientColor.getPositions()[n3], dArray, dArray2), (int)Color.red((int)n4), (int)Color.green((int)n4), (int)Color.blue((int)n4));
            ++n3;
        }
    }

    private int getOpacityAtPosition(double d2, double[] dArray, double[] dArray2) {
        int n = 1;
        while (n < dArray.length) {
            double d3 = dArray[n - 1];
            double d4 = dArray[n];
            if (dArray[n] >= d2) {
                double d5 = (d2 - d3) / (d4 - d3);
                return (int)(255.0 * MiscUtils.lerp(dArray2[n - 1], dArray2[n], d5));
            }
            ++n;
        }
        return (int)(255.0 * dArray2[dArray2.length - 1]);
    }
}

