/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.provider.Settings;
import java.io.Closeable;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLException;
import oz.lottie.L;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.TrimPathContent;
import oz.lottie.animation.keyframe.FloatKeyframeAnimation;
import oz.lottie.utils.MiscUtils;

public final class Utils {
    public static final int SECOND_IN_NANOS = 1000000000;
    private static final PathMeasure pathMeasure = new PathMeasure();
    private static final Path tempPath = new Path();
    private static final Path tempPath2 = new Path();
    private static final float[] points = new float[4];
    private static final float INV_SQRT_2 = (float)(Math.sqrt(2.0) / 2.0);
    private static float dpScale = -1.0f;

    private Utils() {
    }

    public static Path createPath(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        Path path = new Path();
        path.moveTo(pointF.x, pointF.y);
        if (pointF3 != null && pointF4 != null && (pointF3.length() != 0.0f || pointF4.length() != 0.0f)) {
            path.cubicTo(pointF.x + pointF3.x, pointF.y + pointF3.y, pointF2.x + pointF4.x, pointF2.y + pointF4.y, pointF2.x, pointF2.y);
        } else {
            path.lineTo(pointF2.x, pointF2.y);
        }
        return path;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static float getScale(Matrix matrix) {
        Utils.points[0] = 0.0f;
        Utils.points[1] = 0.0f;
        Utils.points[2] = INV_SQRT_2;
        Utils.points[3] = INV_SQRT_2;
        matrix.mapPoints(points);
        float f2 = points[2] - points[0];
        float f3 = points[3] - points[1];
        return (float)Math.hypot(f2, f3);
    }

    public static boolean hasZeroScaleAxis(Matrix matrix) {
        Utils.points[0] = 0.0f;
        Utils.points[1] = 0.0f;
        Utils.points[2] = 37394.73f;
        Utils.points[3] = 39575.234f;
        matrix.mapPoints(points);
        return points[0] == points[2] || points[1] == points[3];
    }

    public static void applyTrimPathIfNeeded(Path path, TrimPathContent trimPathContent) {
        if (trimPathContent == null || trimPathContent.isHidden()) {
            return;
        }
        float f2 = ((FloatKeyframeAnimation)trimPathContent.getStart()).getFloatValue();
        float f3 = ((FloatKeyframeAnimation)trimPathContent.getEnd()).getFloatValue();
        float f4 = ((FloatKeyframeAnimation)trimPathContent.getOffset()).getFloatValue();
        Utils.applyTrimPathIfNeeded(path, f2 / 100.0f, f3 / 100.0f, f4 / 360.0f);
    }

    public static void applyTrimPathIfNeeded(Path path, float f2, float f3, float f4) {
        L.beginSection("applyTrimPathIfNeeded");
        pathMeasure.setPath(path, false);
        float f5 = pathMeasure.getLength();
        if (f2 == 1.0f && f3 == 0.0f) {
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        if (f5 < 1.0f || (double)Math.abs(f3 - f2 - 1.0f) < 0.01) {
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        float f6 = f5 * f2;
        float f7 = f5 * f3;
        float f8 = Math.min(f6, f7);
        float f9 = Math.max(f6, f7);
        float f10 = f4 * f5;
        f8 += f10;
        f9 += f10;
        if (f8 >= f5 && f9 >= f5) {
            f8 = MiscUtils.floorMod(f8, f5);
            f9 = MiscUtils.floorMod(f9, f5);
        }
        if (f8 < 0.0f) {
            f8 = MiscUtils.floorMod(f8, f5);
        }
        if (f9 < 0.0f) {
            f9 = MiscUtils.floorMod(f9, f5);
        }
        if (f8 == f9) {
            path.reset();
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        if (f8 >= f9) {
            f8 -= f5;
        }
        tempPath.reset();
        pathMeasure.getSegment(f8, f9, tempPath, true);
        if (f9 > f5) {
            tempPath2.reset();
            pathMeasure.getSegment(0.0f, f9 % f5, tempPath2, true);
            tempPath.addPath(tempPath2);
        } else if (f8 < 0.0f) {
            tempPath2.reset();
            pathMeasure.getSegment(f5 + f8, f5, tempPath2, true);
            tempPath.addPath(tempPath2);
        }
        path.set(tempPath);
        L.endSection("applyTrimPathIfNeeded");
    }

    public static boolean isAtLeastVersion(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n4) {
            return false;
        }
        if (n > n4) {
            return true;
        }
        if (n2 < n5) {
            return false;
        }
        if (n2 > n5) {
            return true;
        }
        return n3 >= n6;
    }

    public static int hashFor(float f2, float f3, float f4, float f5) {
        int n = 17;
        if (f2 != 0.0f) {
            n = (int)((float)(31 * n) * f2);
        }
        if (f3 != 0.0f) {
            n = (int)((float)(31 * n) * f3);
        }
        if (f4 != 0.0f) {
            n = (int)((float)(31 * n) * f4);
        }
        if (f5 != 0.0f) {
            n = (int)((float)(31 * n) * f5);
        }
        return n;
    }

    public static float dpScale() {
        if (dpScale == -1.0f) {
            dpScale = Resources.getSystem().getDisplayMetrics().density;
        }
        return dpScale;
    }

    public static float getAnimationScale(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f);
        }
        return Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f);
    }

    public static Bitmap resizeBitmapIfNeeded(Bitmap bitmap, int n, int n2) {
        if (bitmap.getWidth() == n && bitmap.getHeight() == n2) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n2, (boolean)true);
        bitmap.recycle();
        return bitmap2;
    }

    public static boolean isNetworkException(Throwable throwable) {
        return throwable instanceof SocketException || throwable instanceof ClosedChannelException || throwable instanceof InterruptedIOException || throwable instanceof ProtocolException || throwable instanceof SSLException || throwable instanceof UnknownHostException || throwable instanceof UnknownServiceException;
    }

    public static void saveLayerCompat(Canvas canvas, RectF rectF, Paint paint) {
        Utils.saveLayerCompat(canvas, rectF, paint, 31);
    }

    public static void saveLayerCompat(Canvas canvas, RectF rectF, Paint paint, int n) {
        L.beginSection("Utils#saveLayer");
        if (Build.VERSION.SDK_INT < 23) {
            canvas.saveLayer(rectF, paint, n);
        } else {
            canvas.saveLayer(rectF, paint);
        }
        L.endSection("Utils#saveLayer");
    }

    public static Bitmap renderPath(Path path) {
        RectF rectF = new RectF();
        path.computeBounds(rectF, false);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)rectF.right), (int)((int)rectF.bottom), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        LPaint lPaint = new LPaint();
        lPaint.setAntiAlias(true);
        lPaint.setColor(-16776961);
        canvas.drawPath(path, (Paint)lPaint);
        return bitmap;
    }
}

