/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import oz.util.barcode.Binarizer;
import oz.util.barcode.LuminanceSource;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.common.BitMatrix;

public final class BinaryBitmap {
    private final Binarizer binarizer;
    private BitMatrix matrix;

    public BinaryBitmap(Binarizer binarizer) {
        if (binarizer == null) {
            throw new IllegalArgumentException("Binarizer must be non-null.");
        }
        this.binarizer = binarizer;
    }

    public int getWidth() {
        return this.binarizer.getWidth();
    }

    public int getHeight() {
        return this.binarizer.getHeight();
    }

    public BitArray getBlackRow(int n, BitArray bitArray) {
        return this.binarizer.getBlackRow(n, bitArray);
    }

    public BitMatrix getBlackMatrix() {
        if (this.matrix == null) {
            this.matrix = this.binarizer.getBlackMatrix();
        }
        return this.matrix;
    }

    public boolean isCropSupported() {
        return this.binarizer.getLuminanceSource().isCropSupported();
    }

    public BinaryBitmap crop(int n, int n2, int n3, int n4) {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().crop(n, n2, n3, n4);
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public boolean isRotateSupported() {
        return this.binarizer.getLuminanceSource().isRotateSupported();
    }

    public BinaryBitmap rotateCounterClockwise() {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().rotateCounterClockwise();
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public BinaryBitmap rotateCounterClockwise45() {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().rotateCounterClockwise45();
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public String toString() {
        try {
            return this.getBlackMatrix().toString();
        }
        catch (NotFoundException notFoundException) {
            return "";
        }
    }
}

