/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec;

import java.nio.charset.Charset;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.aztec.encoder.AztecCode;
import oz.util.barcode.aztec.encoder.Encoder;
import oz.util.barcode.common.BitMatrix;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        String string2 = map == null ? null : (String)map.get((Object)EncodeHintType.CHARACTER_SET);
        Number number = map == null ? (Number)null : (Number)((Number)map.get((Object)EncodeHintType.ERROR_CORRECTION));
        Number number2 = map == null ? (Number)null : (Number)((Number)map.get((Object)EncodeHintType.AZTEC_LAYERS));
        return AztecWriter.encode(string, barcodeFormat, n, n2, string2 == null ? DEFAULT_CHARSET : Charset.forName(string2), number == null ? 33 : number.intValue(), number2 == null ? 0 : number2.intValue());
    }

    private static BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Charset charset, int n3, int n4) {
        if (barcodeFormat != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
        }
        AztecCode aztecCode = Encoder.encode(string.getBytes(charset), n3, n4);
        return AztecWriter.renderResult(aztecCode, n, n2);
    }

    private static BitMatrix renderResult(AztecCode aztecCode, int n, int n2) {
        BitMatrix bitMatrix = aztecCode.getMatrix();
        if (bitMatrix == null) {
            throw new IllegalStateException();
        }
        int n3 = bitMatrix.getWidth();
        int n4 = bitMatrix.getHeight();
        int n5 = Math.max(n, n3);
        int n6 = Math.max(n2, n4);
        int n7 = Math.min(n5 / n3, n6 / n4);
        int n8 = (n5 - n3 * n7) / 2;
        int n9 = (n6 - n4 * n7) / 2;
        BitMatrix bitMatrix2 = new BitMatrix(n5, n6);
        int n10 = 0;
        int n11 = n9;
        while (n10 < n4) {
            int n12 = 0;
            int n13 = n8;
            while (n12 < n3) {
                if (bitMatrix.get(n12, n10)) {
                    bitMatrix2.setRegion(n13, n11, n7, n7);
                }
                ++n12;
                n13 += n7;
            }
            ++n10;
            n11 += n7;
        }
        return bitMatrix2;
    }
}

