/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec.decoder;

import java.util.Arrays;
import oz.util.barcode.FormatException;
import oz.util.barcode.aztec.AztecDetectorResult;
import oz.util.barcode.aztec.decoder.Decoder$Table;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) {
        this.ddata = aztecDetectorResult;
        BitMatrix bitMatrix = aztecDetectorResult.getBits();
        boolean[] blArray = this.extractBits(bitMatrix);
        boolean[] blArray2 = this.correctBits(blArray);
        String string = Decoder.getEncodedData(blArray2);
        return new DecoderResult(null, string, null, null);
    }

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    private static String getEncodedData(boolean[] blArray) {
        int n = blArray.length;
        Decoder$Table decoder$Table = Decoder$Table.UPPER;
        Decoder$Table decoder$Table2 = Decoder$Table.UPPER;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            if (decoder$Table2 == Decoder$Table.BINARY) {
                if (n - n2 < 5) break;
                n4 = Decoder.readCode(blArray, n2, 5);
                n2 += 5;
                if (n4 == 0) {
                    if (n - n2 < 11) break;
                    n4 = Decoder.readCode(blArray, n2, 11) + 31;
                    n2 += 11;
                }
                n3 = 0;
                while (n3 < n4) {
                    if (n - n2 < 8) {
                        n2 = n;
                        break;
                    }
                    int n5 = Decoder.readCode(blArray, n2, 8);
                    stringBuilder.append((char)n5);
                    n2 += 8;
                    ++n3;
                }
                decoder$Table2 = decoder$Table;
                continue;
            }
            int n6 = n4 = decoder$Table2 == Decoder$Table.DIGIT ? 4 : 5;
            if (n - n2 < n4) break;
            n3 = Decoder.readCode(blArray, n2, n4);
            n2 += n4;
            String string = Decoder.getCharacter(decoder$Table2, n3);
            if (string.startsWith("CTRL_")) {
                decoder$Table2 = Decoder.getTable(string.charAt(5));
                if (string.charAt(6) != 'L') continue;
                decoder$Table = decoder$Table2;
                continue;
            }
            stringBuilder.append(string);
            decoder$Table2 = decoder$Table;
        }
        return stringBuilder.toString();
    }

    private static Decoder$Table getTable(char c2) {
        switch (c2) {
            case 'L': {
                return Decoder$Table.LOWER;
            }
            case 'P': {
                return Decoder$Table.PUNCT;
            }
            case 'M': {
                return Decoder$Table.MIXED;
            }
            case 'D': {
                return Decoder$Table.DIGIT;
            }
            case 'B': {
                return Decoder$Table.BINARY;
            }
        }
        return Decoder$Table.UPPER;
    }

    private static String getCharacter(Decoder$Table decoder$Table, int n) {
        switch (decoder$Table) {
            case UPPER: {
                return UPPER_TABLE[n];
            }
            case LOWER: {
                return LOWER_TABLE[n];
            }
            case MIXED: {
                return MIXED_TABLE[n];
            }
            case PUNCT: {
                return PUNCT_TABLE[n];
            }
            case DIGIT: {
                return DIGIT_TABLE[n];
            }
        }
        throw new IllegalStateException("Bad table");
    }

    private boolean[] correctBits(boolean[] blArray) {
        int n;
        GenericGF genericGF;
        int n2;
        if (this.ddata.getNbLayers() <= 2) {
            n2 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            n2 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            n2 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n2 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n3 = this.ddata.getNbDatablocks();
        int n4 = blArray.length / n2;
        if (n4 < n3) {
            throw FormatException.getFormatInstance();
        }
        int n5 = blArray.length % n2;
        int n6 = n4 - n3;
        int[] nArray = new int[n4];
        int n7 = 0;
        while (n7 < n4) {
            nArray[n7] = Decoder.readCode(blArray, n5, n2);
            ++n7;
            n5 += n2;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(genericGF);
            reedSolomonDecoder.decode(nArray, n6);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance();
        }
        int n8 = (1 << n2) - 1;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            n = nArray[n10];
            if (n == 0 || n == n8) {
                throw FormatException.getFormatInstance();
            }
            if (n == 1 || n == n8 - 1) {
                ++n9;
            }
            ++n10;
        }
        boolean[] blArray2 = new boolean[n3 * n2 - n9];
        n = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = nArray[n11];
            if (n12 == 1 || n12 == n8 - 1) {
                Arrays.fill(blArray2, n, n + n2 - 1, n12 > 1);
                n += n2 - 1;
            } else {
                int n13 = n2 - 1;
                while (n13 >= 0) {
                    blArray2[n++] = (n12 & 1 << n13) != 0;
                    --n13;
                }
            }
            ++n11;
        }
        return blArray2;
    }

    boolean[] extractBits(BitMatrix bitMatrix) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = this.ddata.isCompact();
        int n6 = this.ddata.getNbLayers();
        int n7 = bl ? 11 + n6 * 4 : 14 + n6 * 4;
        int[] nArray = new int[n7];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n6, bl)];
        if (bl) {
            n5 = 0;
            while (n5 < nArray.length) {
                nArray[n5] = n5;
                ++n5;
            }
        } else {
            n5 = n7 + 1 + 2 * ((n7 / 2 - 1) / 15);
            n4 = n7 / 2;
            n3 = n5 / 2;
            n2 = 0;
            while (n2 < n4) {
                n = n2 + n2 / 15;
                nArray[n4 - n2 - 1] = n3 - n - 1;
                nArray[n4 + n2] = n3 + n + 1;
                ++n2;
            }
        }
        n5 = 0;
        n4 = 0;
        while (n5 < n6) {
            n3 = bl ? (n6 - n5) * 4 + 9 : (n6 - n5) * 4 + 12;
            n2 = n5 * 2;
            n = n7 - 1 - n2;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = n8 * 2;
                int n10 = 0;
                while (n10 < 2) {
                    blArray[n4 + n9 + n10] = bitMatrix.get(nArray[n2 + n10], nArray[n2 + n8]);
                    blArray[n4 + 2 * n3 + n9 + n10] = bitMatrix.get(nArray[n2 + n8], nArray[n - n10]);
                    blArray[n4 + 4 * n3 + n9 + n10] = bitMatrix.get(nArray[n - n10], nArray[n - n8]);
                    blArray[n4 + 6 * n3 + n9 + n10] = bitMatrix.get(nArray[n - n8], nArray[n2 + n10]);
                    ++n10;
                }
                ++n8;
            }
            n4 += n3 * 8;
            ++n5;
        }
        return blArray;
    }

    private static int readCode(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 <<= 1;
            if (blArray[n4]) {
                n3 |= 1;
            }
            ++n4;
        }
        return n3;
    }

    private static int totalBitsInLayer(int n, boolean bl) {
        return ((bl ? 88 : 112) + 16 * n) * n;
    }
}

