/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.content.Intent;
import android.net.Uri;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import oz.util.barcode.BarcodeFormat;

public final class DecodeFormatManager {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    static final Collection PRODUCT_FORMATS;
    public static final Collection ONE_D_FORMATS;
    public static final Collection TWO_D_FORMATS;
    public static final Collection QR_CODE_FORMATS;
    public static final Collection DATA_MATRIX_FORMATS;

    private DecodeFormatManager() {
    }

    static Collection parseDecodeFormats(Intent intent) {
        List<String> list = null;
        String string = intent.getStringExtra("SCAN_FORMATS");
        if (string != null) {
            list = Arrays.asList(COMMA_PATTERN.split(string));
        }
        return DecodeFormatManager.parseDecodeFormats(list, intent.getStringExtra("SCAN_MODE"));
    }

    static Collection parseDecodeFormats(Uri uri) {
        List<String> list = uri.getQueryParameters("SCAN_FORMATS");
        if (list != null && list.size() == 1 && list.get(0) != null) {
            list = Arrays.asList(COMMA_PATTERN.split((CharSequence)list.get(0)));
        }
        return DecodeFormatManager.parseDecodeFormats(list, uri.getQueryParameter("SCAN_MODE"));
    }

    private static Collection parseDecodeFormats(Iterable iterable, String string) {
        if (iterable != null) {
            EnumSet<BarcodeFormat> enumSet = EnumSet.noneOf(BarcodeFormat.class);
            try {
                for (String string2 : iterable) {
                    enumSet.add(BarcodeFormat.valueOf(string2));
                }
                return enumSet;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (string != null) {
            if ("PRODUCT_MODE".equals(string)) {
                return PRODUCT_FORMATS;
            }
            if ("QR_CODE_MODE".equals(string)) {
                return QR_CODE_FORMATS;
            }
            if ("DATA_MATRIX_MODE".equals(string)) {
                return DATA_MATRIX_FORMATS;
            }
            if ("ONE_D_MODE".equals(string)) {
                return ONE_D_FORMATS;
            }
        }
        return null;
    }

    static {
        QR_CODE_FORMATS = EnumSet.of(BarcodeFormat.QR_CODE);
        DATA_MATRIX_FORMATS = EnumSet.of(BarcodeFormat.DATA_MATRIX);
        PRODUCT_FORMATS = EnumSet.of(BarcodeFormat.UPC_A, new BarcodeFormat[]{BarcodeFormat.UPC_E, BarcodeFormat.EAN_13, BarcodeFormat.EAN_8, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED});
        ONE_D_FORMATS = EnumSet.of(BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.ITF, BarcodeFormat.CODABAR);
        TWO_D_FORMATS = EnumSet.of(BarcodeFormat.DATA_MATRIX, BarcodeFormat.QR_CODE, BarcodeFormat.PDF_417, BarcodeFormat.AZTEC);
        ONE_D_FORMATS.addAll(PRODUCT_FORMATS);
    }
}

