/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import java.util.Arrays;
import oz.util.barcode.common.BitArray;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n) {
        this(n, n);
    }

    public BitMatrix(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = n;
        this.height = n2;
        this.rowSize = n + 31 >> 5;
        this.bits = new int[this.rowSize * n2];
    }

    private BitMatrix(int n, int n2, int n3, int[] nArray) {
        this.width = n;
        this.height = n2;
        this.rowSize = n3;
        this.bits = nArray;
    }

    public boolean get(int n, int n2) {
        int n3 = n2 * this.rowSize + (n >> 5);
        return (this.bits[n3] >>> (n & 0x1F) & 1) != 0;
    }

    public void set(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + (n >> 5);
        this.bits[n4] = this.bits[n4] | 1 << (n & 0x1F);
    }

    public void flip(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + (n >> 5);
        this.bits[n4] = this.bits[n4] ^ 1 << (n & 0x1F);
    }

    public void clear() {
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            this.bits[n2] = 0;
            ++n2;
        }
    }

    public void setRegion(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (n4 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n6 > this.height || n5 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        int n7 = n2;
        while (n7 < n6) {
            int n8 = n7 * this.rowSize;
            int n9 = n;
            while (n9 < n5) {
                int n10 = n8 + (n9 >> 5);
                this.bits[n10] = this.bits[n10] | 1 << (n9 & 0x1F);
                ++n9;
            }
            ++n7;
        }
    }

    public BitArray getRow(int n, BitArray bitArray) {
        if (bitArray == null || bitArray.getSize() < this.width) {
            bitArray = new BitArray(this.width);
        } else {
            bitArray.clear();
        }
        int n2 = n * this.rowSize;
        int n3 = 0;
        while (n3 < this.rowSize) {
            bitArray.setBulk(n3 << 5, this.bits[n2 + n3]);
            ++n3;
        }
        return bitArray;
    }

    public void setRow(int n, BitArray bitArray) {
        System.arraycopy(bitArray.getBitArray(), 0, this.bits, n * this.rowSize, this.rowSize);
    }

    public void rotate180() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        BitArray bitArray = new BitArray(n);
        BitArray bitArray2 = new BitArray(n);
        int n3 = 0;
        while (n3 < (n2 + 1) / 2) {
            bitArray = this.getRow(n3, bitArray);
            bitArray2 = this.getRow(n2 - 1 - n3, bitArray2);
            bitArray.reverse();
            bitArray2.reverse();
            this.setRow(n3, bitArray2);
            this.setRow(n2 - 1 - n3, bitArray);
            ++n3;
        }
    }

    public int[] getEnclosingRectangle() {
        int n;
        int n2 = this.width;
        int n3 = this.height;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.height) {
            n = 0;
            while (n < this.rowSize) {
                int n7 = this.bits[n6 * this.rowSize + n];
                if (n7 != 0) {
                    int n8;
                    if (n6 < n3) {
                        n3 = n6;
                    }
                    if (n6 > n5) {
                        n5 = n6;
                    }
                    if (n * 32 < n2) {
                        n8 = 0;
                        while (n7 << 31 - n8 == 0) {
                            ++n8;
                        }
                        if (n * 32 + n8 < n2) {
                            n2 = n * 32 + n8;
                        }
                    }
                    if (n * 32 + 31 > n4) {
                        n8 = 31;
                        while (n7 >>> n8 == 0) {
                            --n8;
                        }
                        if (n * 32 + n8 > n4) {
                            n4 = n * 32 + n8;
                        }
                    }
                }
                ++n;
            }
            ++n6;
        }
        n6 = n4 - n2;
        n = n5 - n3;
        if (n6 < 0 || n < 0) {
            return null;
        }
        return new int[]{n2, n3, n6, n};
    }

    public int[] getTopLeftOnBit() {
        int n = 0;
        while (n < this.bits.length && this.bits[n] == 0) {
            ++n;
        }
        if (n == this.bits.length) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize << 5;
        int n4 = this.bits[n];
        int n5 = 0;
        while (n4 << 31 - n5 == 0) {
            ++n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int[] getBottomRightOnBit() {
        int n = this.bits.length - 1;
        while (n >= 0 && this.bits[n] == 0) {
            --n;
        }
        if (n < 0) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize << 5;
        int n4 = this.bits[n];
        int n5 = 31;
        while (n4 >>> n5 == 0) {
            --n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        BitMatrix bitMatrix = (BitMatrix)object;
        return this.width == bitMatrix.width && this.height == bitMatrix.height && this.rowSize == bitMatrix.rowSize && Arrays.equals(this.bits, bitMatrix.bits);
    }

    public int hashCode() {
        int n = this.width;
        n = 31 * n + this.width;
        n = 31 * n + this.height;
        n = 31 * n + this.rowSize;
        n = 31 * n + Arrays.hashCode(this.bits);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                stringBuilder.append(this.get(n2, n) ? "X " : "  ");
                ++n2;
            }
            stringBuilder.append('\n');
            ++n;
        }
        return stringBuilder.toString();
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }
}

