/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

final class Codeword {
    private static final int BARCODE_ROW_UNKNOWN = -1;
    private final int startX;
    private final int endX;
    private final int bucket;
    private final int value;
    private int rowNumber = -1;

    Codeword(int n, int n2, int n3, int n4) {
        this.startX = n;
        this.endX = n2;
        this.bucket = n3;
        this.value = n4;
    }

    boolean hasValidRowNumber() {
        return this.isValidRowNumber(this.rowNumber);
    }

    boolean isValidRowNumber(int n) {
        return n != -1 && this.bucket == n % 3 * 3;
    }

    void setRowNumberAsRowIndicatorColumn() {
        this.rowNumber = this.value / 30 * 3 + this.bucket / 3;
    }

    int getWidth() {
        return this.endX - this.startX;
    }

    int getStartX() {
        return this.startX;
    }

    int getEndX() {
        return this.endX;
    }

    int getBucket() {
        return this.bucket;
    }

    int getValue() {
        return this.value;
    }

    int getRowNumber() {
        return this.rowNumber;
    }

    void setRowNumber(int n) {
        this.rowNumber = n;
    }

    public String toString() {
        return String.valueOf(this.rowNumber) + "|" + this.value;
    }
}

