/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.encoder;

import oz.util.barcode.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private final BarcodeRow[] matrix;
    private int currentRow;
    private final int height;
    private final int width;

    BarcodeMatrix(int n, int n2) {
        this.matrix = new BarcodeRow[n];
        int n3 = 0;
        int n4 = this.matrix.length;
        while (n3 < n4) {
            this.matrix[n3] = new BarcodeRow((n2 + 4) * 17 + 1);
            ++n3;
        }
        this.width = n2 * 17;
        this.height = n;
        this.currentRow = -1;
    }

    void set(int n, int n2, byte by) {
        this.matrix[n2].set(n, by);
    }

    void startRow() {
        ++this.currentRow;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int n, int n2) {
        byte[][] byArray = new byte[this.height * n2][this.width * n];
        int n3 = this.height * n2;
        int n4 = 0;
        while (n4 < n3) {
            byArray[n3 - n4 - 1] = this.matrix[n4 / n2].getScaledRow(n);
            ++n4;
        }
        return byArray;
    }
}

