/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.detector;

import java.util.Map;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.common.GridSampler;
import oz.util.barcode.common.PerspectiveTransform;
import oz.util.barcode.common.detector.MathUtils;
import oz.util.barcode.qrcode.decoder.Version;
import oz.util.barcode.qrcode.detector.AlignmentPattern;
import oz.util.barcode.qrcode.detector.AlignmentPatternFinder;
import oz.util.barcode.qrcode.detector.FinderPattern;
import oz.util.barcode.qrcode.detector.FinderPatternFinder;
import oz.util.barcode.qrcode.detector.FinderPatternInfo;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() {
        return this.detect(null);
    }

    public final DetectorResult detect(Map map) {
        this.resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        FinderPatternFinder finderPatternFinder = new FinderPatternFinder(this.image, this.resultPointCallback);
        FinderPatternInfo finderPatternInfo = finderPatternFinder.find(map);
        return this.processFinderPatternInfo(finderPatternInfo);
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo finderPatternInfo) {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPattern finderPattern3 = finderPatternInfo.getTopLeft();
        float f2 = this.calculateModuleSize(finderPattern3, finderPattern2 = finderPatternInfo.getTopRight(), finderPattern = finderPatternInfo.getBottomLeft());
        if (f2 < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = Detector.computeDimension(finderPattern3, finderPattern2, finderPattern, f2);
        Version version = Version.getProvisionalVersionForDimension(n);
        int n2 = version.getDimensionForVersion() - 7;
        AlignmentPattern alignmentPattern = null;
        if (version.getAlignmentPatternCenters().length > 0) {
            float f3 = finderPattern2.getX() - finderPattern3.getX() + finderPattern.getX();
            float f4 = finderPattern2.getY() - finderPattern3.getY() + finderPattern.getY();
            float f5 = 1.0f - 3.0f / (float)n2;
            int n3 = (int)(finderPattern3.getX() + f5 * (f3 - finderPattern3.getX()));
            int n4 = (int)(finderPattern3.getY() + f5 * (f4 - finderPattern3.getY()));
            int n5 = 4;
            while (n5 <= 16) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(f2, n3, n4, n5);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    n5 <<= 1;
                }
            }
        }
        PerspectiveTransform perspectiveTransform = Detector.createTransform(finderPattern3, finderPattern2, finderPattern, alignmentPattern, n);
        BitMatrix bitMatrix = Detector.sampleGrid(this.image, perspectiveTransform, n);
        ResultPoint[] resultPointArray = alignmentPattern == null ? new ResultPoint[]{finderPattern, finderPattern3, finderPattern2} : new ResultPoint[]{finderPattern, finderPattern3, finderPattern2, alignmentPattern};
        return new DetectorResult(bitMatrix, resultPointArray);
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = (float)n - 3.5f;
        if (resultPoint4 != null) {
            f5 = resultPoint4.getX();
            f4 = resultPoint4.getY();
            f2 = f3 = f6 - 3.0f;
        } else {
            f5 = resultPoint2.getX() - resultPoint.getX() + resultPoint3.getX();
            f4 = resultPoint2.getY() - resultPoint.getY() + resultPoint3.getY();
            f3 = f6;
            f2 = f6;
        }
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f6, 3.5f, f3, f2, 3.5f, f6, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), f5, f4, resultPoint3.getX(), resultPoint3.getY());
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n) {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n, perspectiveTransform);
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f2) {
        int n = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f2);
        int n2 = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f2);
        int n3 = (n + n2) / 2 + 7;
        switch (n3 & 3) {
            case 0: {
                ++n3;
                break;
            }
            case 2: {
                --n3;
                break;
            }
            case 3: {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return n3;
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        float f2 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), (int)resultPoint.getY(), (int)resultPoint2.getX(), (int)resultPoint2.getY());
        float f3 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), (int)resultPoint2.getY(), (int)resultPoint.getX(), (int)resultPoint.getY());
        if (Float.isNaN(f2)) {
            return f3 / 7.0f;
        }
        if (Float.isNaN(f3)) {
            return f2 / 7.0f;
        }
        return (f2 + f3) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n, int n2, int n3, int n4) {
        float f2 = this.sizeOfBlackWhiteBlackRun(n, n2, n3, n4);
        float f3 = 1.0f;
        int n5 = n - (n3 - n);
        if (n5 < 0) {
            f3 = (float)n / (float)(n - n5);
            n5 = 0;
        } else if (n5 >= this.image.getWidth()) {
            f3 = (float)(this.image.getWidth() - 1 - n) / (float)(n5 - n);
            n5 = this.image.getWidth() - 1;
        }
        int n6 = (int)((float)n2 - (float)(n4 - n2) * f3);
        f3 = 1.0f;
        if (n6 < 0) {
            f3 = (float)n2 / (float)(n2 - n6);
            n6 = 0;
        } else if (n6 >= this.image.getHeight()) {
            f3 = (float)(this.image.getHeight() - 1 - n2) / (float)(n6 - n2);
            n6 = this.image.getHeight() - 1;
        }
        n5 = (int)((float)n + (float)(n5 - n) * f3);
        return (f2 += this.sizeOfBlackWhiteBlackRun(n, n2, n5, n6)) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
        if (bl) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        n5 = Math.abs(n3 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = -n5 / 2;
        int n8 = n < n3 ? 1 : -1;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = 0;
        int n11 = n3 + n8;
        int n12 = n;
        int n13 = n2;
        while (n12 != n11) {
            int n14;
            int n15;
            if (n10 == 1 == this.image.get(n15 = bl ? n13 : n12, n14 = bl ? n12 : n13)) {
                if (n10 == 2) {
                    return MathUtils.distance(n12, n13, n, n2);
                }
                ++n10;
            }
            if ((n7 += n6) > 0) {
                if (n13 == n4) break;
                n13 += n9;
                n7 -= n5;
            }
            n12 += n8;
        }
        if (n10 == 2) {
            return MathUtils.distance(n3 + n8, n4, n, n2);
        }
        return Float.NaN;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f2, int n, int n2, float f3) {
        int n3 = (int)(f3 * f2);
        int n4 = Math.max(0, n - n3);
        int n5 = Math.min(this.image.getWidth() - 1, n + n3);
        if ((float)(n5 - n4) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n6 = Math.max(0, n2 - n3);
        int n7 = Math.min(this.image.getHeight() - 1, n2 + n3);
        if ((float)(n7 - n6) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        AlignmentPatternFinder alignmentPatternFinder = new AlignmentPatternFinder(this.image, n4, n6, n5 - n4, n7 - n6, f2, this.resultPointCallback);
        return alignmentPatternFinder.find();
    }
}

