/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.util.drawable.TextDrawable;
import oz.util.drawable.TextDrawable$Builder;
import oz.viewer.ui.df.DFUtils;

public class DFAutoProgressButton
extends LinearLayout {
    private static final int DP_TEXT_PADDING = 5;
    private static final int DP_ONOFF_RAD = 9;
    private static final int DP_ONOFF_WIDTH = 40;
    private static final int DP_ONOFF_ON_WIDTH = 30;
    private static final int DP_ONOFF_BORDER = 1;
    private static final int SP_TEXT = 13;
    private static final int SP_ONOFF = 13;
    private static final int COLOR_TEXT = -1;
    private static final int COLOR_TEXT_ON = 0;
    private static final int COLOR_TEXT_ON_BG = -1;
    private static final float COLOR_ALPHA_TEXT = 0.8f;
    private static final float COLOR_ALPHA_ONOFF = 0.8f;
    private static final int COLOR_TEXT_OFF_BORDER = Color.argb((int)76, (int)255, (int)255, (int)255);
    private static final int COLOR_TEXT_OFF = Color.argb((int)204, (int)255, (int)255, (int)255);
    private static final PorterDuff.Mode MODE_COLOR_TEXT_ON = PorterDuff.Mode.CLEAR;
    private static final String TEXT_ON = "ON";
    private static final String TEXT_OFF = "OFF";
    private String TEXT_AUTOPROGRESS = "\uc790\ub3d9 \uc9c4\ud589";
    private TextView mTextView;
    private View mOnOffView;
    private String mLocale;

    public DFAutoProgressButton(Context context, String string) {
        super(context);
        this.mLocale = string;
        this.init();
    }

    private void init() {
        this.TEXT_AUTOPROGRESS = this.mLocale.equalsIgnoreCase("en-US") ? "Auto" : "\uc790\ub3d9 \uc9c4\ud589";
        this.setGravity(17);
        this.setOrientation(1);
        this.initTextView();
        this.initOnOffBtn();
    }

    private void initTextView() {
        Context context = this.getContext();
        this.mTextView = new TextView(context);
        this.mTextView.setAlpha(0.8f);
        this.mTextView.setTextColor(-1);
        this.mTextView.setText((CharSequence)this.TEXT_AUTOPROGRESS);
        this.mTextView.setTextSize(13.0f);
        this.mTextView.setGravity(17);
        int n = DFUtils.toDP(context, 5.0f);
        this.mTextView.setPadding(n, 0, n, n);
        this.addView((View)this.mTextView);
    }

    private void initOnOffBtn() {
        Context context = this.getContext();
        this.mOnOffView = new View(context);
        this.mOnOffView.setAlpha(0.8f);
        this.mOnOffView.setBackground(this.createOnOffDrawable());
        this.mOnOffView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(DFUtils.toDP(context, 40.0f), DFUtils.toDP(context, 18.0f)));
        this.addView(this.mOnOffView);
    }

    private Drawable createOnOffDrawable() {
        Context context = this.getContext();
        TextDrawable$Builder textDrawable$Builder = (TextDrawable$Builder)TextDrawable.builder().roundRect(DFUtils.toDP(this.getContext(), 9.0f));
        textDrawable$Builder.bold();
        textDrawable$Builder.useFont(Typeface.SANS_SERIF);
        textDrawable$Builder.fontSize(DFUtils.toSP(context, 13.0f));
        textDrawable$Builder.withBorder(DFUtils.toDP(context, 1.0f));
        textDrawable$Builder.borderColor = COLOR_TEXT_OFF_BORDER;
        textDrawable$Builder.textColor = COLOR_TEXT_OFF;
        TextDrawable textDrawable = textDrawable$Builder.build(TEXT_OFF, 0);
        textDrawable$Builder.withBorder(0.0f);
        textDrawable$Builder.fiilRect = true;
        textDrawable$Builder.fillColor = -1;
        textDrawable$Builder.textColorMode = MODE_COLOR_TEXT_ON;
        textDrawable$Builder.textColor = 0;
        TextDrawable textDrawable2 = textDrawable$Builder.build(TEXT_ON, 0);
        textDrawable2.setIntrinsicWidth(DFUtils.toDP(context, 30.0f));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)textDrawable2);
        stateListDrawable.addState(new int[]{-16842913}, (Drawable)textDrawable);
        return stateListDrawable;
    }
}

