/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import java.util.ArrayList;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFInputCompSelectable;
import oz.viewer.ui.df.view.DFInputCompSelectable$ItemInfo;
import oz.viewer.ui.df.view.DFSelectItemView;

class DFInputCompSelectable$ItemsAdapter
extends BaseAdapter
implements View.OnClickListener {
    public static final int ID_BUTTON1 = 256;
    public static final int ITEM_TYPE_VISIBLE = 0;
    public static final int ITEM_TYPE_INVISIBLE = 1;
    public static final int ITEM_TYPE_COUNT = 2;
    private boolean mIsAllowEmpty;
    private boolean mIsMultiSelectable;
    private boolean mIsVoice;
    private int mItemWidth;
    private ArrayList mItems;
    private DFInputCompSelectable$ItemInfo mEmptyItem;
    final /* synthetic */ DFInputCompSelectable this$0;

    public DFInputCompSelectable$ItemsAdapter(DFInputCompSelectable dFInputCompSelectable) {
        this.this$0 = dFInputCompSelectable;
        this.init();
    }

    private void init() {
        this.mItems = DFInputCompSelectable.access$000(this.this$0).getItems();
        if (this.mItems == null) {
            this.mItems = new ArrayList();
        }
        this.mIsAllowEmpty = DFInputCompSelectable.access$000(this.this$0).isAllowEmpty();
        this.mIsMultiSelectable = DFInputCompSelectable.access$000(this.this$0).isMultiselectable();
        if (this.mItems.isEmpty() || this.mIsAllowEmpty) {
            this.initEmptyItem();
        }
    }

    private void initEmptyItem() {
        this.mEmptyItem = new DFInputCompSelectable$ItemInfo();
        this.mEmptyItem.item = "\uc120\ud0dd \uc548\ud568";
    }

    public void setItemWidth(int n) {
        this.mItemWidth = n;
    }

    public int getItemWidth() {
        return this.mItemWidth;
    }

    public void setIsVoice(boolean bl) {
        this.mIsVoice = bl;
    }

    public void setSelectedItems(String string) {
        this.clearSelectAll();
        if (string != null && !string.isEmpty() && !string.equals("-1")) {
            String[] stringArray = string.split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                this.setSelectItem(stringArray[j]);
            }
        }
    }

    private void setSelectItem(String string) {
        int n;
        if (string != null && (n = Integer.parseInt(string)) >= 0) {
            ((DFInputCompSelectable$ItemInfo)this.mItems.get((int)n)).selected = true;
        }
    }

    public String getSelectedString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.mItems.size(); ++j) {
            DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo = (DFInputCompSelectable$ItemInfo)this.mItems.get(j);
            if (!dFInputCompSelectable$ItemInfo.selected) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(j);
        }
        return DFInputCompSelectable.access$000(this.this$0).getParamValue(stringBuffer.toString());
    }

    public int getItemViewType(int n) {
        int n2 = 0;
        DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo = (DFInputCompSelectable$ItemInfo)this.getItem(n);
        if (dFInputCompSelectable$ItemInfo != null && !dFInputCompSelectable$ItemInfo.visible) {
            n2 = 1;
        }
        return n2;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getCount() {
        return this.mItems.size() + (this.mEmptyItem != null ? 1 : 0);
    }

    public Object getItem(int n) {
        if (this.mEmptyItem != null && n + 1 == this.getCount()) {
            return this.mEmptyItem;
        }
        return this.mItems.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        int n2 = this.getItemViewType(n);
        if (view == null) {
            view = this.createItemView(n2);
        }
        view.setTag((Object)n);
        this.updateItemView(n, n2, view);
        return view;
    }

    private View createItemView(int n) {
        if (n == 0) {
            int n2 = DFUtils.toDP(this.this$0.getContext(), 5.0f);
            int n3 = DFUtils.toDP(this.this$0.getContext(), 20.0f);
            LinearLayout linearLayout = new LinearLayout(this.this$0.getContext());
            linearLayout.setOrientation(0);
            linearLayout.setPadding(n3, n2, 0, n2);
            linearLayout.setGravity(16);
            DFSelectItemView dFSelectItemView = new DFSelectItemView(this.this$0.getContext());
            dFSelectItemView.setId(256);
            dFSelectItemView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mItemWidth, -2));
            dFSelectItemView.setOnClickListener(this);
            dFSelectItemView.setOnTouchListener(this.this$0.DFOnTouchListener);
            dFSelectItemView.setTag(linearLayout);
            linearLayout.addView((View)dFSelectItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            return linearLayout;
        }
        if (n == 1) {
            LinearLayout linearLayout = new LinearLayout(this.this$0.getContext());
            return linearLayout;
        }
        return null;
    }

    private void updateItemView(int n, int n2, View view) {
        DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo = this.getItemFromView(view);
        if (dFInputCompSelectable$ItemInfo != null && n2 == 0) {
            DFSelectItemView dFSelectItemView = (DFSelectItemView)view.findViewById(256);
            if (dFSelectItemView.getLayoutParams().width != this.mItemWidth) {
                dFSelectItemView.getLayoutParams().width = this.mItemWidth;
            }
            if (dFInputCompSelectable$ItemInfo == this.mEmptyItem) {
                dFSelectItemView.setText(dFInputCompSelectable$ItemInfo.item);
            } else {
                dFSelectItemView.setText(String.format("%d) %s", n + 1, dFInputCompSelectable$ItemInfo.item));
            }
            dFSelectItemView.setEnabled(dFInputCompSelectable$ItemInfo.enable);
            dFSelectItemView.setSelected(dFInputCompSelectable$ItemInfo.selected, this.mIsVoice);
        }
    }

    private int objToPostion(Object object) {
        int n = -1;
        if (object != null) {
            n = (Integer)object;
        }
        return n;
    }

    private DFInputCompSelectable$ItemInfo getItemFromObj(Object object) {
        DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo = null;
        int n = this.objToPostion(object);
        if (n >= 0 && n < this.getCount()) {
            dFInputCompSelectable$ItemInfo = (DFInputCompSelectable$ItemInfo)this.getItem(n);
        }
        return dFInputCompSelectable$ItemInfo;
    }

    private DFInputCompSelectable$ItemInfo getItemFromView(View view) {
        if (view != null) {
            return this.getItemFromObj(view.getTag());
        }
        return null;
    }

    private void clearSelectAll() {
        for (int j = 0; j < this.mItems.size(); ++j) {
            ((DFInputCompSelectable$ItemInfo)this.mItems.get((int)j)).selected = false;
        }
    }

    private int getSelectedItemCountExceptTarget(DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo) {
        int n = 0;
        for (int j = 0; j < this.mItems.size(); ++j) {
            DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo2 = (DFInputCompSelectable$ItemInfo)this.mItems.get(j);
            if (dFInputCompSelectable$ItemInfo2 == dFInputCompSelectable$ItemInfo || !dFInputCompSelectable$ItemInfo2.selected) continue;
            ++n;
        }
        return n;
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 256: {
                DFInputCompSelectable$ItemInfo dFInputCompSelectable$ItemInfo = this.getItemFromView((View)view.getTag());
                if (dFInputCompSelectable$ItemInfo == null) break;
                boolean bl = true;
                boolean bl2 = true;
                if (dFInputCompSelectable$ItemInfo == this.mEmptyItem) {
                    this.clearSelectAll();
                    dFInputCompSelectable$ItemInfo.selected = true;
                } else {
                    int n = this.getSelectedItemCountExceptTarget(dFInputCompSelectable$ItemInfo);
                    boolean bl3 = bl2 = !dFInputCompSelectable$ItemInfo.selected;
                    if (!bl2 && !this.mIsAllowEmpty && n == 0) {
                        bl = false;
                    } else if (!this.mIsMultiSelectable && n > 0) {
                        this.clearSelectAll();
                        bl2 = true;
                    }
                }
                if (bl) {
                    dFInputCompSelectable$ItemInfo.selected = bl2;
                    if (this.mEmptyItem != null && dFInputCompSelectable$ItemInfo != this.mEmptyItem && this.getSelectedItemCountExceptTarget(null) > 0) {
                        this.mEmptyItem.selected = false;
                    }
                    this.notifyDataSetInvalidated();
                }
                if (this.mIsMultiSelectable) break;
                this.this$0.callOnConfirm();
                break;
            }
        }
    }

    static /* synthetic */ boolean access$100(DFInputCompSelectable$ItemsAdapter dFInputCompSelectable$ItemsAdapter) {
        return dFInputCompSelectable$ItemsAdapter.mIsMultiSelectable;
    }
}

