/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.ViewGroup;
import android.widget.AbsSeekBar;
import android.widget.SeekBar;
import java.lang.reflect.Field;
import oz.main.OZStorage;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableChildView;
import oz.viewer.ui.edit.AEditableUtil;
import oz.viewer.ui.edit.ASeekBar$ASeekBarHandler;
import oz.viewer.ui.edit.ASeekBar$CustomInsetDrawable;

public class ASeekBar
extends SeekBar
implements SeekBar.OnSeekBarChangeListener,
AEditableChildView {
    private static final int THUMBSIZE = 24;
    private static final int THUMBSIZE_SCALED = 48;
    private boolean mFixedDisabled;
    private int mMaxValue = 23;
    private static final int MIN_VALUE = 1;
    private int mThumbScaledPx;
    private AEditableBaseView mBaseView;
    private ASeekBar$ASeekBarHandler mHandler;

    public ASeekBar(Context context, AEditableBaseView aEditableBaseView) {
        super(context);
        this.mBaseView = aEditableBaseView;
        this.init();
    }

    public void setFixedEnabled(boolean bl) {
        this.mFixedDisabled = bl;
        if (this.mFixedDisabled) {
            this.setClickable(false);
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.mFixedDisabled) {
            super.setEnabled(false);
        } else {
            super.setEnabled(bl);
        }
    }

    public AEditableBaseView getBaseView() {
        return this.mBaseView;
    }

    private void init_DisabledAlpha() {
        try {
            Field field = AbsSeekBar.class.getDeclaredField("mDisabledAlpha");
            if (field != null) {
                field.setAccessible(true);
                field.setFloat(this, 1.0f);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void init_Thumb() {
        Bitmap bitmap = AEditableUtil.getBitmapFromAssetPath(this.getContext(), "resource/popup_icon_thumb@2x.png");
        if (bitmap != null) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mThumbScaledPx, (int)this.mThumbScaledPx, (boolean)true));
            bitmapDrawable.setBounds(0, 0, this.mThumbScaledPx, this.mThumbScaledPx);
            this.setThumb((Drawable)bitmapDrawable);
        }
    }

    private void init_Progress() {
        this.setMax(this.mMaxValue);
        this.setProgressFromBaseView();
        this.setThumbOffset(0);
    }

    public int getMinValue() {
        return 1;
    }

    private boolean setProgressFromBaseView() {
        return this.setProgressThick(this.getBaseView().getSelectedPenThick());
    }

    private boolean setProgressThick(int n) {
        boolean bl = false;
        switch (this.getBaseView().getCommentMode()) {
            case 0: 
            case 1: 
            case 3: {
                this.setProgress(n);
                bl = true;
            }
        }
        return bl;
    }

    private boolean setProgressToBaseView(int n) {
        boolean bl = false;
        switch (this.getBaseView().getCommentMode()) {
            case 0: 
            case 1: 
            case 3: {
                this.getBaseView().setSelectedPenThick(n);
                bl = true;
            }
        }
        return bl;
    }

    private void init() {
        this.mHandler = new ASeekBar$ASeekBarHandler(this, null);
        this.mThumbScaledPx = OZStorage.DpToPx(this.getContext(), 48.0f, true);
        this.init_DisabledAlpha();
        this.init_Thumb();
        OZStorage.excuteMethodIfAPILevelAndOver(21, this.getClass(), "setSplitTrack", new Class[]{Boolean.TYPE}, new Object[]{false}, this);
        this.init_Progress();
        this.setVisibility(4);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, this.mThumbScaledPx));
        this.setOnSeekBarChangeListener(this);
        this.requestRefresh();
    }

    public void requestRefresh() {
        this.mHandler.requestRefresh();
    }

    private Drawable makeProgressDrawable(int n, int n2) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setCornerRadius(50.0f);
        gradientDrawable.setColor(n2);
        int n3 = 24 - n + this.mMaxValue;
        int n4 = OZStorage.DpToPx(this.getContext(), n3 / 2, true);
        int n5 = this.mThumbScaledPx;
        ASeekBar$CustomInsetDrawable aSeekBar$CustomInsetDrawable = new ASeekBar$CustomInsetDrawable(this, (Drawable)gradientDrawable, 0, n4, 0, n4, n5);
        return aSeekBar$CustomInsetDrawable;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        this.setProgressDrawable(this.makeProgressDrawable(++n, this.getBaseView().getSelectedPenColor()));
        if (this.setProgressToBaseView(n)) {
            this.getBaseView().getBottomBar().getCommentAble().setThickValue(this.getBaseView().getCommentMode(), this.getBaseView().getSelectedPenThick());
        }
    }

    static /* synthetic */ Drawable access$100(ASeekBar aSeekBar, int n, int n2) {
        return aSeekBar.makeProgressDrawable(n, n2);
    }
}

