/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.history;

import oz.viewer.ui.history.HistoryNavigationUtil;

public class HistoryNavigationCompData {
    public static final int TYPE_OZ_IC_BUTTON = 51;
    public static final int TYPE_OZ_IC_RADIOBUTTON = 52;
    public static final int TYPE_OZ_IC_CHECKBOX = 53;
    public static final int TYPE_OZ_IC_TEXTBOX = 54;
    public static final int TYPE_OZ_IC_LISTBOX = 55;
    public static final int TYPE_OZ_IC_SIGNPAD = 57;
    public static final int TYPE_OZ_IC_VOICERECORDER = 58;
    public static final int TYPE_OZ_IC_DATETIMEPICKER = 59;
    public static final int TYPE_OZ_IC_NUMERICUPDOWN = 60;
    public static final int TYPE_OZ_IC_RADIOBUTTONGROUP = 81;
    public static final int TYPE_OZ_IC_IMAGEPICKER = 82;
    public static final int TYPE_OZ_IC_ATTACHMENT = 89;
    public int id;
    public int compType;
    public int docIndex;
    public int version;
    public String name;
    public String value;
    public String srcValue;
    public boolean selectedValueOriginal;
    public boolean selectedValue;
    public boolean selectedValue2;
    private int page;
    private int zorder;
    private int uniqueKey = 0;
    private String md5 = null;

    public HistoryNavigationCompData(int n, int n2) {
        this.page = n;
        this.zorder = n2;
    }

    public int getPage() {
        return this.page;
    }

    public int getZOrder() {
        return this.zorder;
    }

    public void setSelectedValue(boolean bl) {
        this.selectedValueOriginal = bl;
        this.selectedValue = bl;
        this.selectedValue2 = bl;
    }

    public String getUniqueCompString() {
        return String.format("%d_%d", this.page, this.zorder);
    }

    public int getUniqueCompId() {
        if (this.uniqueKey == 0) {
            this.uniqueKey = this.getUniqueCompString().hashCode();
        }
        return this.uniqueKey;
    }

    public String getMD5() {
        if (this.md5 == null) {
            this.md5 = HistoryNavigationUtil.getMD5(this.value);
        }
        return this.md5;
    }

    public boolean isEqualValue(HistoryNavigationCompData historyNavigationCompData) {
        boolean bl = false;
        if (historyNavigationCompData != null) {
            if (this == historyNavigationCompData) {
                bl = true;
            } else if (this.id == historyNavigationCompData.id && this.docIndex == historyNavigationCompData.docIndex && this.page == historyNavigationCompData.page && this.compType == historyNavigationCompData.compType) {
                if (this.value.isEmpty() && historyNavigationCompData.value.isEmpty()) {
                    bl = true;
                } else if (this.value.isEmpty() == historyNavigationCompData.value.isEmpty()) {
                    switch (this.compType) {
                        case 57: 
                        case 58: 
                        case 82: 
                        case 89: {
                            String string = this.getMD5();
                            String string2 = historyNavigationCompData.getMD5();
                            if (string == null || string2 == null) break;
                            bl = this.md5.equals(string2);
                            break;
                        }
                        case 53: {
                            bl = this.srcValue.equals(historyNavigationCompData.srcValue);
                            break;
                        }
                        default: {
                            bl = this.value.equals(historyNavigationCompData.value);
                        }
                    }
                }
            }
        }
        return bl;
    }
}

