/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main;

import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import java.lang.ref.WeakReference;
import oz.viewer.ui.main.HorizontalPicker;

final class HorizontalPicker$Marquee
extends Handler {
    private static final int MARQUEE_DELAY = 1200;
    private static final int MARQUEE_RESTART_DELAY = 1200;
    private static final int MARQUEE_RESOLUTION = 33;
    private static final int MARQUEE_PIXELS_PER_SECOND = 30;
    private static final byte MARQUEE_STOPPED = 0;
    private static final byte MARQUEE_STARTING = 1;
    private static final byte MARQUEE_RUNNING = 2;
    private static final int MESSAGE_START = 1;
    private static final int MESSAGE_TICK = 2;
    private static final int MESSAGE_RESTART = 3;
    private final WeakReference mView;
    private final WeakReference mLayout;
    private byte mStatus = 0;
    private final float mScrollUnit;
    private float mMaxScroll;
    private float mGhostStart;
    private float mGhostOffset;
    private int mRepeatLimit;
    private float mScroll;
    private boolean mRtl;

    HorizontalPicker$Marquee(HorizontalPicker horizontalPicker, Layout layout, boolean bl) {
        float f2 = horizontalPicker.getContext().getResources().getDisplayMetrics().density;
        float f3 = 30.0f * f2 / 33.0f;
        this.mScrollUnit = bl ? -f3 : f3;
        this.mView = new WeakReference<HorizontalPicker>(horizontalPicker);
        this.mLayout = new WeakReference<Layout>(layout);
        this.mRtl = bl;
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.mStatus = (byte)2;
                this.tick();
                break;
            }
            case 2: {
                this.tick();
                break;
            }
            case 3: {
                if (this.mStatus != 2) break;
                if (this.mRepeatLimit >= 0) {
                    --this.mRepeatLimit;
                }
                this.start(this.mRepeatLimit);
            }
        }
    }

    void tick() {
        if (this.mStatus != 2) {
            return;
        }
        this.removeMessages(2);
        HorizontalPicker horizontalPicker = (HorizontalPicker)((Object)this.mView.get());
        Layout layout = (Layout)this.mLayout.get();
        if (horizontalPicker != null && layout != null && (horizontalPicker.isFocused() || horizontalPicker.isSelected())) {
            this.mScroll += this.mScrollUnit;
            if (Math.abs(this.mScroll) > this.mMaxScroll) {
                this.mScroll = this.mMaxScroll;
                if (this.mRtl) {
                    this.mScroll *= -1.0f;
                }
                this.sendEmptyMessageDelayed(3, 1200L);
            } else {
                this.sendEmptyMessageDelayed(2, 33L);
            }
            horizontalPicker.invalidate();
        }
    }

    void stop() {
        this.mStatus = 0;
        this.removeMessages(1);
        this.removeMessages(3);
        this.removeMessages(2);
        this.resetScroll();
    }

    private void resetScroll() {
        this.mScroll = 0.0f;
        HorizontalPicker horizontalPicker = (HorizontalPicker)((Object)this.mView.get());
        if (horizontalPicker != null) {
            horizontalPicker.invalidate();
        }
    }

    void start(int n) {
        if (n == 0) {
            this.stop();
            return;
        }
        this.mRepeatLimit = n;
        HorizontalPicker horizontalPicker = (HorizontalPicker)((Object)this.mView.get());
        Layout layout = (Layout)this.mLayout.get();
        if (horizontalPicker != null && layout != null) {
            this.mStatus = 1;
            this.mScroll = 0.0f;
            int n2 = HorizontalPicker.access$100(horizontalPicker);
            float f2 = layout.getLineWidth(0);
            float f3 = (float)n2 / 3.0f;
            this.mGhostStart = f2 - (float)n2 + f3;
            this.mMaxScroll = this.mGhostStart + (float)n2;
            this.mGhostOffset = f2 + f3;
            if (this.mRtl) {
                this.mGhostOffset *= -1.0f;
            }
            horizontalPicker.invalidate();
            this.sendEmptyMessageDelayed(1, 1200L);
        }
    }

    float getGhostOffset() {
        return this.mGhostOffset;
    }

    float getScroll() {
        return this.mScroll;
    }

    boolean shouldDrawGhost() {
        return this.mStatus == 2 && Math.abs(this.mScroll) > this.mGhostStart;
    }
}

