/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.IOException;
import oz.client.shape.ui.ICEditWnd;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.util.OZButton;
import oz.util.OZScrollableDialogBuilder;
import oz.viewer.ui.main.OZBarcodeInputDialog$1;
import oz.viewer.ui.main.OZBarcodeInputDialog$2;
import oz.viewer.ui.main.OZBarcodeInputDialog$3;
import oz.viewer.ui.main.OZBarcodeInputDialog$4;
import oz.viewer.ui.main.OZBarcodeInputDialog$5;
import oz.viewer.ui.main.OZBarcodeInputDialog$6;
import oz.viewer.ui.main.OZBarcodeInputDialog$7;
import oz.viewer.ui.main.OZBarcodeInputDialog$8;

public class OZBarcodeInputDialog
extends ScrollView
implements View.OnClickListener {
    int bg_alpha = 0;
    int bg_color = 0;
    boolean m_isMultiLine = false;
    ICEditWnd mParent = null;
    Dialog mPopupDlg = null;
    TextView blankView1 = null;
    TextView blankView2 = null;
    Context mContext = null;
    LinearLayout llayout = null;
    int TOOLBAR_ICON_HEIGHT = 40;
    String cmtInputMode = "resource/comment05@2x.png";
    private final int ICON_ID_MEMO_LABEL = 1000;
    private final int ICON_ID_MEMO_INIT = 1001;
    private final int ICON_ID_MEMO_COMPLETE = 1002;
    String m_caption = "";
    EditText m_labelEditText;
    OZButton m_initBtn;
    OZButton m_confirmBtn;
    Dialog mDialogLabel = null;

    public void show() {
        this.dialogLabelCreate();
    }

    public void dispose() {
        if (this.llayout != null && this.llayout.getChildCount() > 0) {
            this.llayout.removeAllViews();
        }
        this.llayout = null;
        if (this.mPopupDlg != null) {
            this.mPopupDlg = null;
        }
        this.blankView1 = null;
        this.blankView2 = null;
    }

    public OZBarcodeInputDialog(Context context, ICEditWnd iCEditWnd, boolean bl, String string) {
        super(context);
        this.mContext = context;
        this.mParent = iCEditWnd;
        this.m_caption = string;
        this.m_isMultiLine = bl;
        try {
            Drawable drawable2 = OZStorage.getDrawable(this.getResources().getAssets().open(OZStorage.getImagePath(this.cmtInputMode)));
            this.TOOLBAR_ICON_HEIGHT = OZStorage.getButtonSizeWithScreen(drawable2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.llayout = new LinearLayout(context);
        this.llayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 48.0f));
        this.llayout.setOrientation(1);
        this.llayout.setOnTouchListener((View.OnTouchListener)new OZBarcodeInputDialog$1(this));
        this.inits();
        this.setResizeLayerTop();
    }

    public void removeAll() {
        if (this.llayout.getChildCount() > 0) {
            this.llayout.removeAllViews();
        }
    }

    public void inits() {
        this.removeAll();
    }

    public void setToolbarBackgroundColor(int n) {
        if (n >= 0) {
            int n2 = Color.red((int)n);
            int n3 = Color.green((int)n);
            int n4 = Color.blue((int)n);
            this.bg_color = Color.rgb((int)n4, (int)n3, (int)n2);
            this.llayout.setBackgroundColor(Color.argb((int)this.bg_alpha, (int)n4, (int)n3, (int)n2));
        }
    }

    public void setAddView() {
        if (this.getChildCount() == 0) {
            this.addView((View)this.llayout);
            this.postInvalidate();
        }
    }

    public boolean isShowingDialog() {
        return this.mDialogLabel != null && this.mDialogLabel.isShowing();
    }

    public void closeShowingDialog() {
        if (this.mDialogLabel != null && this.mDialogLabel.isShowing()) {
            this.mDialogLabel.dismiss();
            this.mDialogLabel = null;
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        this.closeShowingDialog();
        super.onConfigurationChanged(configuration);
    }

    public void btnInvalidate() {
    }

    public void performInitBtnClick() {
        this.m_labelEditText.setText((CharSequence)"");
        this.mParent.nativeOnChange("");
    }

    private void dialogLabelCreate() {
        OZBarcodeInputDialog$2 oZBarcodeInputDialog$2 = new OZBarcodeInputDialog$2(this);
        OZBarcodeInputDialog$3 oZBarcodeInputDialog$3 = new OZBarcodeInputDialog$3(this);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setPadding(0, OZStorage.padding_10, 0, OZStorage.padding_10);
        if (!this.m_isMultiLine && this.m_caption.length() > 0) {
            this.m_caption = this.m_caption.replaceAll("[\n\r]", "");
        }
        this.m_initBtn = this.getMenuButton("resource/default_btn_empty_d@2x.png", 1001, false);
        this.m_confirmBtn = this.getMenuButton("resource/default_btn_confirm_icon@2x.png", 1002, false);
        this.m_initBtn.setBackgroundDrawable(this.m_initBtn.getBackground(), (ColorFilter)new PorterDuffColorFilter(-1, PorterDuff.Mode.SRC_ATOP));
        this.m_confirmBtn.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(-1, PorterDuff.Mode.SRC_ATOP));
        if (this.m_caption.length() > 0) {
            this.m_initBtn.setEnabled(true);
        } else {
            this.m_initBtn.setEnabled(false);
        }
        OZScrollableDialogBuilder oZScrollableDialogBuilder = this.createBuilder(this.m_initBtn, this.m_confirmBtn, oZBarcodeInputDialog$2, oZBarcodeInputDialog$3);
        this.m_labelEditText = new EditText(this.getContext());
        this.mParent.keyboardTypeSetting_Normal(this.m_labelEditText);
        this.mParent.setFilters(this.m_labelEditText);
        this.m_labelEditText.setHeight(300);
        this.m_labelEditText.setGravity(48);
        this.m_labelEditText.setText((CharSequence)this.m_caption);
        this.m_labelEditText.setTextColor(-16777216);
        this.m_labelEditText.setBackgroundColor(-1);
        this.m_labelEditText.setImeOptions(6 | (Build.VERSION.SDK_INT > 10 ? 0x2000000 : 0x10000000));
        this.mParent.m_barcodeEditText = this.m_labelEditText;
        this.m_labelEditText.addTextChangedListener((TextWatcher)new OZBarcodeInputDialog$4(this));
        this.m_labelEditText.setOnKeyListener((View.OnKeyListener)new OZBarcodeInputDialog$5(this));
        oZScrollableDialogBuilder.addView((View)this.m_labelEditText, 12100);
        this.mDialogLabel = oZScrollableDialogBuilder.create();
        this.mDialogLabel.setOnKeyListener((DialogInterface.OnKeyListener)new OZBarcodeInputDialog$6(this));
        this.mDialogLabel.setOnDismissListener((DialogInterface.OnDismissListener)new OZBarcodeInputDialog$7(this));
        this.mDialogLabel.show();
        this.m_labelEditText.requestFocus();
        this.postDelayed(new OZBarcodeInputDialog$8(this), 100L);
    }

    private EditText getEditText(EditText editText, int n) {
        editText = new EditText(this.getContext());
        editText.setFocusableInTouchMode(false);
        editText.setGravity(5);
        editText.setText((CharSequence)Integer.toString(n));
        editText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(OZStorage.getPaddingInt(70.0f), OZStorage.getPaddingInt(40.0f)));
        editText.setTextColor(-8355712);
        editText.setBackgroundColor(-1);
        return editText;
    }

    public EditText getBarcodeInputEditText() {
        return this.m_labelEditText;
    }

    private OZScrollableDialogBuilder createBuilder(OZButton oZButton, OZButton oZButton2, View.OnClickListener onClickListener, View.OnClickListener onClickListener2) {
        OZScrollableDialogBuilder oZScrollableDialogBuilder = new OZScrollableDialogBuilder(this.getContext());
        oZScrollableDialogBuilder.setUseCustomView(true);
        oZScrollableDialogBuilder.setMinWidth(OZStorage.DpToPx(this.getContext(), 550.0f, true, true, true));
        oZScrollableDialogBuilder.addButton(oZButton, 11230, onClickListener);
        oZScrollableDialogBuilder.setUseCustomTitle(15);
        if (oZButton2 != null && onClickListener2 != null) {
            oZScrollableDialogBuilder.addButton(oZButton2, 11230, onClickListener2);
        } else {
            Drawable drawable2 = OZStorage.getResourceDrawable(oZButton.getBackground());
            TextView textView = new TextView(this.getContext());
            textView.setWidth(drawable2.getIntrinsicWidth());
            oZScrollableDialogBuilder.addView((View)textView, 11230, 0);
        }
        return oZScrollableDialogBuilder;
    }

    private void addMenuLayout(LinearLayout linearLayout, View view, LinearLayout.LayoutParams layoutParams, int n) {
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView(view);
        linearLayout2.setGravity(n);
    }

    private OZButton getMenuButton(String string, int n, boolean bl) {
        OZButton oZButton = this.getOZButtonFromResouce(new String[]{"OZInputComponentConfirmButton.Resource"}, string, null, true);
        if (!bl) {
            this.setOZButtonCommonInit(oZButton);
        } else {
            float f2 = oZButton.getBackground().getIntrinsicHeight();
            float f3 = oZButton.getBackground().getIntrinsicWidth();
            oZButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)f3 * 2 / 3, (int)f2 * 2 / 3));
            oZButton.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(-12949861, PorterDuff.Mode.SRC_ATOP));
        }
        return oZButton;
    }

    private TextView getTextView(String string) {
        TextView textView = new TextView(this.getContext());
        textView.setBackgroundColor(-2500135);
        textView.setPadding(OZStorage.padding_10, OZStorage.padding_5, OZStorage.padding_10, OZStorage.padding_5);
        textView.setText((CharSequence)string);
        textView.setTextColor(-16777216);
        return textView;
    }

    private OZButton getOZButtonFromResouce(String[] stringArray, String string, String string2, boolean bl) {
        return this.getOZButtonFromResouce(null, stringArray, string, string2, bl);
    }

    private OZButton getOZButtonFromResouce(OZButton oZButton, String[] stringArray, String string, String string2, boolean bl) {
        if (oZButton == null) {
            oZButton = new OZButton(this.getContext());
        }
        oZButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        boolean bl2 = false;
        if (string2 != null && !bl2 && !oZButton.isResource()) {
            oZButton.setText(OZAndroidResource.getResource(string2));
        }
        if (string != null && !bl2) {
            try {
                this.changeDrawable(oZButton, string, bl);
                bl2 = true;
                oZButton.setResource(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e((String)this.toString(), (String)("Failed get image : " + string));
            }
        }
        return oZButton;
    }

    protected void changeDrawable(OZButton oZButton, String string, boolean bl) {
        try {
            Drawable drawable2 = OZStorage.getDrawable(this.getContext().getResources().getAssets().open(OZStorage.getImagePath(string)));
            if (bl) {
                int n = new TextView(this.getContext()).getTextColors().getDefaultColor();
                drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(n, PorterDuff.Mode.SRC_ATOP));
            }
            oZButton.setBackgroundDrawable(drawable2, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setOZButtonCommonInit(OZButton oZButton) {
        if (oZButton != null) {
            if (!oZButton.isResource()) {
                oZButton.setPadding(0, 0, 0, 0);
                this.setOZButtonLayout(oZButton);
            } else {
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(oZButton.getBackground().getIntrinsicWidth(), oZButton.getBackground().getIntrinsicHeight());
                oZButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private void setOZButtonLayout(OZButton oZButton) {
        if (Build.VERSION.SDK_INT >= 21) {
            oZButton.setAllCaps(false);
        }
        float f2 = oZButton.getBackground().getIntrinsicHeight();
        float f3 = oZButton.getBackground().getIntrinsicWidth();
        if (OZStorage.getDensityDPI() <= 1.5f) {
            f2 *= OZStorage.getDensityDPI();
            f3 *= OZStorage.getDensityDPI();
        }
        oZButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)f3, (int)f2));
    }

    public void onClick(View view) {
    }

    public void setResizeLayerTop() {
        int n = 0;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, this.TOOLBAR_ICON_HEIGHT * (this.llayout.getChildCount() + 1) + n, 3);
        layoutParams.topMargin = n;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.llayout.setPadding(this.llayout.getPaddingLeft(), this.getPaddingTop() + this.TOOLBAR_ICON_HEIGHT, this.getPaddingRight(), this.getPaddingBottom());
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return false;
    }
}

