/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import oz.main.OZPageView;
import oz.viewer.ui.main.overlay.ATableManager$1;
import oz.viewer.ui.main.overlay.ATableView;
import oz.viewer.ui.main.overlay.ATableView$AThumbnailInfo;
import oz.viewer.ui.main.overlay.ATableView$AThumbnailSubjectTypeface;
import oz.viewer.ui.main.overlay.ATableView$ThumbnailView;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;

public class ATableManager
extends AutoHideAbleOZOverlayView {
    public static final int TREEMODE = 1;
    public static final int THUMBNAILMODE = 2;
    public static final int NOTHINGMODE = 3;
    private int mMode = 3;
    private boolean mIsAutoHideTree;
    private boolean mIsAutoHideThumbnail;
    private boolean mIsCloseTreeAtAutoHide;
    private ATableView mView = new ATableView(this.getContext());
    private String[] mTreeData;

    public ATableManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 10);
        this.mView.setManager(this);
        this.mView.setVisibility(4);
    }

    public void setThumbnailSectionInfo(String string, int n, int n2, int n3) {
        this.mView.setThumbnailTypeface(new ATableView$AThumbnailSubjectTypeface());
        if (string != null && !string.isEmpty()) {
            Typeface typeface = null;
            if (string.startsWith("res://")) {
                typeface = OZPageView.getTypeface("res/" + string.substring("res://".length()), 1);
            } else {
                try {
                    typeface = Typeface.createFromFile((String)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (typeface != null) {
                this.mView.getThumbnailTypeface().setFont(typeface);
            }
        }
        if (n != 0) {
            this.mView.getThumbnailTypeface().setFont(Typeface.create((Typeface)this.mView.getThumbnailTypeface().getFont(), (int)n));
        }
        this.mView.getThumbnailTypeface().setColor(n3);
        this.mView.getThumbnailTypeface().setSize(TypedValue.applyDimension((int)2, (float)n2, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
    }

    private void setMode(int n) {
        this.mMode = n;
    }

    public void setTreeTitle(String string) {
        this.mView.setHeaderTitle(string);
    }

    public void clearThumbnail() {
        this.mView.updateThumbnail();
        this.mView.initThumbnail();
    }

    public void waitThumbnail() {
        this.mView.getThumbnailTaskManager().waitTask();
    }

    public void updateThumbnail() {
        this.mView.updateThumbnail();
    }

    public void updateThumbnail(int n) {
        this.mView.updateThumbnail(n);
    }

    public void setAutoHideTree(boolean bl) {
        this.mIsAutoHideTree = bl;
    }

    public void setAutoHideThumbnail(boolean bl) {
        this.mIsAutoHideThumbnail = bl;
    }

    public void setCloseTreeAtAutoHide(boolean bl) {
        this.mIsCloseTreeAtAutoHide = bl;
    }

    public void setTreeData(String string, int n, int n2) {
        if (this.mTreeData == null || this.mTreeData.length != n2) {
            this.mTreeData = new String[n2];
        }
        this.mTreeData[n] = string;
    }

    public void selectThumbnailPage(int n) {
        this.mView.postDelayed(new ATableManager$1(this, n), 200L);
    }

    public void updateThumbnailBitmap() {
        this.mView.updateThumbnail();
    }

    public void setTreeMode() {
        this.mView.setTreeMode(this.mTreeData);
        this.mTreeData = null;
        this.setMode(1);
    }

    public void setThumbnailInfo(int n, boolean bl, String string, int n2, boolean bl2) {
        ATableView$AThumbnailInfo aTableView$AThumbnailInfo = new ATableView$AThumbnailInfo();
        aTableView$AThumbnailInfo.docIndex = n;
        aTableView$AThumbnailInfo.isShowDisplayName = bl;
        aTableView$AThumbnailInfo.displayName = string;
        aTableView$AThumbnailInfo.pageCount = n2;
        aTableView$AThumbnailInfo.hasCloseBtn = bl2;
        this.mView.setThumbnailInfo(aTableView$AThumbnailInfo);
    }

    public void setThumbnailMode(boolean bl) {
        this.mView.setThumbnailMode(bl);
        if (bl) {
            this.setMode(2);
        }
    }

    public void setNothingMode() {
        this.mView.setEmptyMode();
        this.setMode(3);
    }

    public boolean isTreeMode() {
        return this.getMode() == 1;
    }

    public boolean isThumbnailMode() {
        return this.getMode() == 2;
    }

    public boolean isNothingMode() {
        return !this.isTreeMode() && !this.isThumbnailMode();
    }

    public int getMode() {
        return this.mMode;
    }

    public ATableView$ThumbnailView getThumbnailView(int n) {
        return this.mView.getThumbnailTaskManager().getThumbnailView(n);
    }

    public ATableView$ThumbnailView createThumbnailView(int n) {
        return this.mView.getThumbnailTaskManager().createThumbnailView(n);
    }

    public ATableView$ThumbnailView createOrGetThumbnailView(int n) {
        ATableView$ThumbnailView aTableView$ThumbnailView = this.getThumbnailView(n);
        if (aTableView$ThumbnailView == null) {
            aTableView$ThumbnailView = this.createThumbnailView(n);
        }
        return aTableView$ThumbnailView;
    }

    public void setTableWidth(int n) {
        this.mView.setRealWidth(n);
    }

    public boolean IsTableVisible() {
        return this.mView.getTableViewVisble();
    }

    public void openTable() {
        this.mView.openTable();
    }

    public void closeTable() {
        this.mView.closeTable();
    }

    public void show() {
        super.show();
        this.mView.updateToggleButton();
    }

    public void hide() {
        super.hide();
        this.mView.clearToggleTouch();
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)this.getParent().findLayout(22000);
        frameLayout.addView((View)this.mView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void setAutoHideEnable(boolean bl) {
        this.setAutoHideTree(bl);
        this.setAutoHideThumbnail(bl);
    }

    public boolean isAutoHideEnable() {
        boolean bl = true;
        switch (this.getMode()) {
            default: {
                bl = this.mIsAutoHideTree;
                break;
            }
            case 2: {
                bl = this.mIsAutoHideThumbnail;
            }
        }
        return bl;
    }

    protected void OnHideAnimationEnd() {
        super.OnHideAnimationEnd();
        if (this.mView != null && this.mIsCloseTreeAtAutoHide && !this.isAutoHideCancel()) {
            this.mView.closeTable();
        }
    }

    static /* synthetic */ ATableView access$000(ATableManager aTableManager) {
        return aTableManager.mView;
    }
}

