package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.type.BooleanResult;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

/**
 * ACMSからのJSONがbooleanのresultという項目を予め持っているクラスです。booleanのresultを持つJSONに対応するクラスを作成するときはこのクラスを継承してください。
 * @author Taejin Hong
 * @version 1.0.0
 *
 */
public class ContentCheckDeliverableJSON extends AcmsCommonJSON {
	public static final String Result = "result";
	public static final String ConmparisonResult = "comparisonResult";
	
	public boolean result;
	public boolean comparisonResult;
	
	public ContentCheckDeliverableJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException, JSONException {
		super.parse(json);
		result = BooleanResult.success.name().equals(getString(json, Result));
		comparisonResult = BooleanResult.success.name().equals(getString(json, ConmparisonResult));
	}
}
