package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.acms.type.RequirePasswordChangeCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.adf.util.StringUtil;

public class NewAppStoreLoginJSON extends AcmsBooleanResultJSON {
	public static final String Sid = "sid";
	public static final String UserName = "userName";
	public static final String UserId = "userId";
	public static final String WorkerCode = "workerCode";

	public String sid;
	public RequirePasswordChangeCode requirePasswordChange;
	public String userName;
	public int userId;
	public String workerCode;
	
	public NewAppStoreLoginJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		super.parse(json);
		sid = getString(json, Sid);
		userName = getString(json, UserName, StringUtil.Empty);
		int code = getInt(json, RequirePasswordChangeJSON.RequirePasswordChange);
		requirePasswordChange = RequirePasswordChangeCode.parse(String.valueOf(code));
		if (json.has(UserId)) {
			userId = getInt(json,UserId);
		}
		if (json.has(WorkerCode)) {
			workerCode = getString(json, WorkerCode, StringUtil.Empty);
		}
	}
}
