package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

public class CheckSendLogParameters extends HttpParameterObject {
	/**
	 * ユーザ認証キー
	 * @since 1.0.0
	 */
	protected String sid;
	/**
	 * 端末タイプ
	 * @since 1.0.0
	 */
	protected int deviceTypeId;
	/**
	 * 端末ID
	 * @since 1.0.0
	 */
	protected String uid;
	/**
	 * 端末のMACアドレス
	 * @since 1.0.0
	 */
	protected String ma;

	/**
	 * {@link NewAppStoreLoginParameters} クラスのインスタンスを初期化します。
	 * @param sid ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
	 * @param deviceTypeId 端末タイプです。
     * @param uid 端末IDです。
	 * @param ma 端末のMACアドレスです。
	 * @throws IllegalArgumentException 引数のどれかが半角英数字と'_'、'-'ではありません。
	 * @since 1.0.0
	 */
	public CheckSendLogParameters(String sid, int deviceTypeId, String uid, String ma) throws IllegalArgumentException {
		this.sid = sid;
		this.deviceTypeId = deviceTypeId;
		this.uid = uid;
		this.ma = ma;
	}

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public int getDeviceTypeId() {
        return deviceTypeId;
    }

    public void setDeviceTypeId(int deviceTypeId) {
        this.deviceTypeId = deviceTypeId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getMa() {
        return ma;
    }

    public void setMa(String ma) {
        this.ma = ma;
    }
}
