package jp.agentec.abook.abv.bl.acms.client.parameters;

/**
 * ユーザ認証（UID）用のパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class EnterpriseNewLoginParameters extends AbstractAcmsLoginParameters {

	private String uid;
	private int installType;
	private int guest;

	public EnterpriseNewLoginParameters(String loginId, String memberPassword, int appId, String appVersion, int deviceTypeId, String deviceToken, String uid, int guest) throws IllegalArgumentException {
		super(loginId, memberPassword, appId, appVersion, deviceTypeId, deviceToken, uid);
		this.ma = null;
		this.uid = uid;
		this.installType = 0; // 0固定
		this.guest = guest;
	}

	public String getUid() {
		return uid;
	}

	public int getInstallType() {
		return installType;
	}
	
	public int getGuest() {
		return guest;
	}
}
