package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * @author Lee-mk
 * @version 1.0.0
 */
public class FavoriteUserParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private Integer targetUserId;


	/**
	 * {@link FavoriteUserParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @param targetUserId お気に入りリクエスト対象になるユーザのID。
	 * @since 1.0.0
	 */
	public FavoriteUserParameters(String sid, String cmd, Integer targetUserId) {
		this.sid = sid;
		this.cmd = cmd;
		this.targetUserId = targetUserId;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return コマンド。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	/**
	 * 対象ユーザIDを返します。
	 * @return 対象ユーザID。
	 * @since 1.0.0
	 */
	public Integer getTargetUserId() {
		return targetUserId;
	}
}
