package jp.agentec.abook.abv.bl.common.constant;

/**
 * Created by leemk on 2021/03/03.
 */

public interface ABookCommConstants {

    String TAG = "ABookComm";

    //AbookComm専用の共通インターフェース
    interface KEY {
        String CHAT_ROOM_ID = "chatRoomId";
        String CHAT_ROOM_NAME = "chatRoomName";
        String TYPE = "type";
        String FAVORITE_REGISTER_DATE = "favoriteRegisterDate";
        String UNREAD_COUNT = "unreadCount";
        String MESSAGE = "message";
        String MESSAGE_TYPE = "messageType";
        String INSERT_DATE = "insertDate";
        String USER_COUNT = "userCount";
        String LOGIN_ID = "loginId";
        String PROFILE_IMAGE_PATH = "profileImagePath";
        String SELF_FLG = "selfFlg";
        String SHOP_MEMBER_NAME = "shopMemberName";
        String SHOP_MEMBER_ID = "shopMemberId";
        String PROFILE_URL = "profileUrl";
        String GROUP_NAME = "groupName";
        String GROUP_ID = "groupId";
        String GROUP_PATH = "groupPath";
        String GROUP_IDS = "groupIds";
        String GROUP_PATH_LIST = "groupPathList";
        String IS_FAVORITE = "isFavorite";
        String CHILD_GROUP_LIST = "childGroupList";
        String GROUP_USER_LIST = "groupUserList";
        String BODY = "body";
        String CHECKED = "checked";

        String CHAT_ROOM_INFO = "chatRoomInfo";
        String ROOM_ID = "roomId";
        String ROOM_NAME = "roomName";
        String ATTEND_USERS = "attendUsers";
        String MEMBER_NAME = "memberName";
        String DEL_FLG = "delFlg";
        String ROOM_TYPE = "roomType";
        String GROUP_ID_LIST = "groupIdList";
        String MESSAGE_INFO_LIST = "messageInfoList";
        String MESSAGE_ID = "messageId";
        String SHOP_ID = "shopId";
        String TIME = "time";
        String GROUP_INFO_LIST = "groupInfoList";
        String PARENT_GROUP_ID = "parentGroupId";
        String GROUP_MEMBER_LIST = "groupMemberList";
        String CHAT_ROOM_INFO_LIST = "chatRoomInfoList";
        String LAST_MESSAGE_INFO = "lastMessageInfo";
        String FAVORITE_USER_IDS = "favoriteUserIds";
        String FAVORITE_GROUP_IDS = "favoriteGroupIds";
        String LAST_REQUEST_DATE = "lastRequestDate";

        String ARCHIVE_INFO_LIST = "archiveInfoList";
        String ARCHIVE_INFO = "archiveInfo";
        String ARCHIVE_ID = "archiveId";
        String ARCHIVE_NAME = "archiveName";
        String ARCHIVE_DATE = "archiveDate";
        String ARCHIVE_TYPE = "archiveType";
        String SAVE_USER_ID = "saveUserId";
        String FILE_PATH = "filePath";
        String ATTEND_USER_IDS = "attendUserIds";
        String ARCHIVE_INFO_LAST_UPDATE_DATE = "archiveInfoLastUpdateDate";


        String CONTENT_ID = "contentId";
        String CONTENT_NAEM = "contentName";
        String THUMBNAIL_NORMAL_PATH = "thumbnailNormalPath";
        String THUMBNAIL_BIG_PATH = "thumbnailBigPath";
        String RESOURCE_PATH = "resourcePath";

        String COLLABORATION_DEATAIL_ID = "collaborationDetailId";

        String MY_SHOPE_MEMBER_ID = "myShopMemberId";

        String ROOT_GROUP_ID = "rootGroupId";

        String GROUP_MEMBER_UPDATED_DATE = "groupMemberUpdatedDate";
        String MESSAGE_UPDATED_DATE = "MessageUpdatedDate";
        String ARCHIVE_UPDATED_DATE = "ArchiveUpdatedDate";
        String HTTP_STATUS = "httpStatus";
        interface API_KIND {
            String USER = "user";
            String ROOM = "room";
            String GROUP = "group";
            String CHAT = "chat";
            String FILE = "file";
            String COLLABORATION = "collaboration";
        }
        String SHOP_NAME = "shopName";
        String LANGUAGE_CODE = "languageCode";
        String SID = "sid";
        String ROOM_ID_UPPERCASE_D = "roomID";
        String CHAT_URL = "chatURL";
        String CMS_URL = "cmsURL";
        String IS_ONLINE = "isOnline";
        String IS_MOBILE = "isMobile";
        String PLATFORM = "platform";
        String COLLABORATION_TYPE = "collaborationType";
    }

    interface FLAG {
        interface SCREEN_FLG {
            Integer NAME_CARD = 0;
            Integer MAKE_ROOM = 1;
        }
        interface SELF_FLAG {
            Integer OFF = 0;
            Integer ON = 1;
        }
        interface DEL_FLAG {
            Integer EXIST = 0;
            Integer DELETE = 1;
        }
        interface ROOM_TYPE {
            Integer GROUP = 0;
            Integer DM = 1;
            Integer ALL = 2;
        }
        interface MESSAGE_TYPE {
            Integer TEXT = 0;
            Integer PHOTO = 1;
            Integer VIDEO = 2;
            Integer SYSTEM = 3;
            Integer COLLABORATION_START = 4;
            Integer COLLABORATION_END = 5;
        }

        interface COLLABORATION_TYPE {
            Integer AUDIO = 0;
            Integer CAMERA = 2;
            Integer VIDEO = 3;
            Integer DOCUMENT = 4;
            Integer BOARD = 5;
        }

        interface COLLABORATION_JOIN_FLG {
            Integer CREATE = 0;
            Integer JOIN = 1;
            Integer INVITE = 2;
        }

        interface ROOM_VIEW_FLAG {
            Integer VISIBLE = 0;
            Integer INVISIBLE = 1;
        }

        Integer GROUP_REQUEST_ALL = 0;
    }

    interface SIZE {
        Integer MAX_FAVORITE_COUNT = 100;
        Integer MESSAGE_PAGING_SIZE = 100;
    }

    interface COLLABORATION {
        interface INVITE_COLLABORATION {
            String EN = "inviteCollaboration";
            String JP = "\u5354\u696d";
            String KR = "\ud611\uc5c5";
        }
        interface COLLABORATION_AUDIO {
            String EN = "audio collaboration";
            String JP = "通話協業";
            String KR = "통화협업";
        }
        interface COLLABORATION_CAMERA {
            String EN = "image collaboration";
            String JP = "写真協業";
            String KR = "사진협업";
        }
        interface COLLABORATION_VIDEO {
            String EN = "video collaboration";
            String JP = "動画協業";
            String KR = "영상협업";
        }
        interface COLLABORATION_DOCUMENT {
            String EN = "document collaboration";
            String JP = "文書協業";
            String KR = "문서협업";
        }
        interface COLLABORATION_BOARD {
            String EN = "board collaboration";
            String JP = "ボード協業";
            String KR = "보드협업";
        }
    }

    String FILE_SAVE_PATH = "/data/user/0/jp.co.agentec.abookplus.check/files/";

    String NETWORK_ERROR_PLACE_HOLDER = "file:///android_asset/chat/public_new/chat.html";
    String CHAT_PAGE_URL = "file:///android_asset/chat/public_new/chat.html";
    String CHAT_ROOM_PAGE_URL = "file:///android_asset/chat/public_new/chat_room.html";
    String ARCHIVE_URL = "file:///android_asset/chat/public_new/archive.html";
    String ARCHIVE_DETAIL_URL = "file:///android_asset/chat/public_new/archive_detail.html";
    String CONTACT_URL = "file:///android_asset/chat/public_new/contact.html";
    String COLLABORATION_PAGE_URL = "file:///android_asset/chat/public_new/collaboration.html";
    String DEFAULT_CHECKSUM = "0000000000";
    String PLATFORM_NAME = "android";
    String CHAT_MESSAGE_SEPERATOR = "<::split>";

    int PUSH_MESSAGE_DLG_REQUEST_CODE = 200;
    interface PUSH_MESSAGE_DLG_RESULT {
        int OK = 0;
        int CANCEL = 1;
    }

    // ABookCheckで、onActivityResultのリクエストコードとして使用されている
    int ABOOK_CHECK_TASK_IMAGE = 103;
    int ABOOK_CHECK_TASK_VIDEO = 104;
    int ABOOK_CHECK_SELECT_SCENE = 105;
}
