package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ContentObjectLogDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.StringUtil;

public class ContentObjectLogDao extends AbstractDao {

	/**
	 * {@link MemberInfoDao} のインスタンスを初期化します。
	 * context アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	ContentObjectLogDao() {
	}

	@Override
	protected ContentObjectLogDto convert(Cursor cursor) {
		ContentObjectLogDto dto = new ContentObjectLogDto();

		int colnum = cursor.getColumnIndex("object_log_id");
		if (colnum != -1) {
			dto.objectLogId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("reading_log_id");
		if (colnum != -1) {
			dto.readingLogId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("action_date");
		if (colnum != -1) {
			dto.actionDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("resume_date");
		if (colnum != -1) {
			dto.resumeDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("page_num");
		if (colnum != -1) {
			dto.pageNum = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("object_id");
		if (colnum != -1) {
			dto.objectId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("resource_id");
		if (colnum != -1) {
			dto.resourceId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("media_type");
		if (colnum != -1) {
			dto.mediaType = cursor.getShort(colnum);
		}
		colnum = cursor.getColumnIndex("action_type");
		if (colnum != -1) {
			if(StringUtil.isNullOrEmpty(cursor.getString(colnum))){
				dto.actionType = null;
			} else {
				dto.actionType = cursor.getInt(colnum);
			}
		}
		colnum = cursor.getColumnIndex("action_value");
		if (colnum != -1) {
			dto.actionValue = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("action_time");
		if (colnum != -1) {
			dto.actionTime = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("location_x");
		if (colnum != -1) {
			dto.locationX = cursor.getDouble(colnum);
		}
		colnum = cursor.getColumnIndex("location_y");
		if (colnum != -1) {
			dto.locationY = cursor.getDouble(colnum);
		}
		colnum = cursor.getColumnIndex("location_height");
		if (colnum != -1) {
			dto.locationHeight = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("location_width");
		if (colnum != -1) {
			dto.locationWidth = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("event_type");
		if (colnum != -1) {
			dto.eventType = cursor.getString(colnum);
		}

		return dto;
	}

	public int getNewContentObjectLogId() {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT ");
		sql.append(" COALESCE(MAX(object_log_id)+1,1)");
		sql.append(" FROM l_content_object_log");
		return rawQueryGetInt(sql.toString(), null);
	}
	
	public ContentObjectLogDto getContentObjectLog(int objectLogId) {
		String[] args = new String[] { "" + objectLogId};
		return rawQueryGetDto("select * from l_content_object_log where object_log_id=?", args, ContentObjectLogDto.class);
	}

	public List<ContentObjectLogDto> getContentObjectLogs(long contentId, int readingLogId) {
		String[] args = new String[] { "" + contentId, "" + readingLogId };
		return rawQueryGetDtoList("select * from l_content_object_log where content_id=? and reading_log_id=?", args, ContentObjectLogDto.class);
	}

	public void insertContentObjectLog(ContentObjectLogDto dto) {
		try {
			insert("insert into l_content_object_log (object_log_id, reading_log_id, action_date, resume_date, content_id, page_num, object_id, resource_id, media_type, action_type, action_value, action_time, location_x, location_y, location_height, location_width, event_type) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
		} catch (Exception e) { // 司会者で再起動時ここでなぜかconstraint errorとなる。無視。
			Logger.w("ContentObjectLogDao", e.toString());
		}
	}

	public boolean updateContentObjectLog(ContentObjectLogDto dto) {
		long count = update("update l_content_object_log set reading_log_id=?, action_date=?, resume_date=?, content_id=?, page_num=?, object_id=?, resource_id=?, media_type=?, action_type=?, action_value=?, action_time=?, location_x=?, location_y=?, location_height=?, location_width=?, event_type=? where object_log_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public boolean deleteContentObjectLog(long contentId, int readingLogId) {
		String[] args = new String[] { "" + contentId, "" + readingLogId};
		long ret = delete("l_content_object_log", "content_id=? and reading_log_id=?", args);
		return ret > 0;
	}
}