package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class LContentObjectLog extends SQLiteTableScript {
	
	public LContentObjectLog() {
		super();
	}

	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();

		sql.append(" CREATE TABLE l_content_object_log ( ");
		sql.append("        object_log_id INTEGER NOT NULL ");
		sql.append("      , reading_log_id INTEGER NOT NULL ");
		sql.append("      , action_date DATETIME NOT NULL ");
		sql.append("      , resume_date DATETIME ");
		sql.append("      , content_id BIGINT NOT NULL ");
		sql.append("      , page_num INTEGER NOT NULL ");
		sql.append("      , object_id BIGINT NOT NULL ");
		sql.append("      , resource_id BIGINT NOT NULL ");
		sql.append("      , media_type INTEGER NOT NULL ");
		sql.append("      , action_type INTEGER ");
		sql.append("      , action_value TEXT ");
		sql.append("      , action_time INTEGER ");
		sql.append("      , location_x REAL NOT NULL ");
		sql.append("      , location_y REAL NOT NULL ");
		sql.append("      , location_height INTEGER NOT NULL ");
		sql.append("      , location_width INTEGER NOT NULL ");
		sql.append("      , event_type  TEXT ");
		sql.append("      , PRIMARY KEY (object_log_id) ");
		sql.append("      , FOREIGN KEY (reading_log_id) REFERENCES l_content_reading_log (reading_log_id) ");
		sql.append(" ) ");

		ddl.add(sql.toString());

		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
