package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class MAcms extends SQLiteTableScript {

	public MAcms() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		Logger.d("DATA", "create version : %s", version);
		
		//	since 1.5.0
		sql.append(" CREATE TABLE m_acms ( ");
		sql.append("        url_path VARCHAR(256) NOT NULL ");
		sql.append("      , last_announce_change_password_date DATE ");
		sql.append("      , acms_address VARCHAR(256) ");
		sql.append("      , download_server_address VARCHAR(256) ");
		sql.append("      , websocket_server_http_url VARCHAR(256) ");
		sql.append("      , websocket_server_ws_url VARCHAR(256) ");
		sql.append("      , schedulelist_last_fetch_date VARCHAR(256) ");
		sql.append("      , contentversion_last_fetch_date VARCHAR(256) ");
		sql.append("      , PRIMARY KEY (url_path) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... arg2) {
		return null;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

}
