package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;
import jp.agentec.adf.util.StringUtil;


public class TContentPage extends SQLiteTableScript {
	
	public TContentPage() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		sql.append(" CREATE TABLE t_content_page ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , page_num INTEGER NOT NULL ");
		sql.append("      , page_text TEXT ");
		sql.append("      , page_thumbnail_name TEXT ");
		sql.append("      , hashed_thumbnail_header TEXT ");
		sql.append("      , PRIMARY KEY (content_id, page_num) ");
		sql.append("      , FOREIGN KEY (content_id) REFERENCES t_content (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

//		sql.append(" CREATE INDEX idx_content_page_1 ON t_content_page ( "); // 不要削除
//		sql.append("        page_text ");
//		sql.append(" ) ");
//		
//		ddl.add(sql.toString());
		
		ddl.add(" CREATE INDEX idx_content_page_num ON t_content_page (page_num) ");
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
