package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by leej on 2018/08/31.
 */

public class TTask extends SQLiteTableScript {

    public TTask() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_task ( ");
        sql.append("        task_key TEXT NOT NULL ");
        sql.append("      , task_id BIGINT ");
        sql.append("      , operation_id BIGINT NOT NULL ");
        sql.append("      , task_code VARCHAR(64) ");
        sql.append("      , task_status INTEGER ");
        sql.append("      , task_hotspot_info TEXT ");
        sql.append("      , del_flg BOOLEAN DEFAULT 0 ");
        sql.append("      , hotspot_changed_flg BOOLEAN DEFAULT 0 ");
        sql.append("      , phase_no SMALLINT DEFAULT 0 ");
        sql.append("      , phase_status SMALLINT DEFAULT 1 ");
        sql.append("      , process_key TEXT ");
        sql.append("      , process_status SMALLINT DEFAULT 0 ");
        sql.append("      , task_name TEXT ");
        sql.append("      , PRIMARY KEY (task_key) ");
        sql.append(" ) ");
        ddl.add(sql.toString());

        return ddl;
    }


    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_2_360) {
            ddl.add("ALTER TABLE t_task ADD COLUMN phase_no SMALLINT DEFAULT 0 ");
            //ローカル保存時、次の作業を活性化するため、初回保存時には作業中（１）に設定
            ddl.add("ALTER TABLE t_task ADD COLUMN phase_status SMALLINT DEFAULT 1 ");
            ddl.add("ALTER TABLE t_task ADD COLUMN process_key TEXT ");
            ddl.add("ALTER TABLE t_task ADD COLUMN process_status SMALLINT DEFAULT 0 ");
            ddl.add("ALTER TABLE t_task ADD COLUMN task_name TEXT ");
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
