package jp.agentec.abook.abv.bl.acms.client;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import jp.agentec.abook.abv.bl.acms.client.json.AcmsMessageJSON;
import jp.agentec.abook.abv.bl.acms.client.json.AuthLevelJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.AcmsParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.AddMemberGroupParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.ContentDownloadLogParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.ContentReadingLogParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.EnterpriseLoginParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.ServerTimeParameters;
import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.abook.abv.bl.acms.type.InstallType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.nw.PCNetworkAdapter;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.adf.net.http.HttpRequestSender;
import jp.agentec.adf.util.StringUtil;

import org.junit.BeforeClass;
import org.junit.Test;

public class AcmsClientTest {
	private static boolean created = false;

	@BeforeClass
	public static void setUp() throws Exception {
		ABVEnvironment.getInstance().isReader = true;
		if (!created) {
			DBConnector conn = DBConnector.getInstance();
			SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
			conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
			((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
			created = true;
		}
	}

	@Test
	public void getAuthLevel() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		String sid = "13711753344d3d0d8cff3fdab33bf2a8";
		ABVEnvironment.getInstance().acmsAddress = "http://web3.agentec.jp/acms";
		AuthLevelJSON json = AcmsClient.getInstance("ts", new PCNetworkAdapter()).getAuthLevel(new AcmsParameters(sid));
		
		System.out.println(" status=" + json.httpStatus + " authLevel=" + json.authLevel);
	}
	
	@Test
	public void addMemberGroup() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		String sid = "13711753344d3d0d8cff3fdab33bf2a8";
		ABVEnvironment.getInstance().acmsAddress = "http://localhost:28080/acms";
		AcmsMessageJSON json = AcmsClient.getInstance("ts", new PCNetworkAdapter()).addMemberGroup(new AddMemberGroupParameters(sid, "開発部", Locale.getDefault().getLanguage()));
		
		System.out.println(" status=" + json.httpStatus + " message=" + json.message + " errorMessage=" + json.errorMessage);
	}
	

	@Test
	public void uploadLogFile() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		String sid = "764a0a02814b11552edd3c72014d0768";
		File uploadFile = new File("D:/var/log/php_error");
		ABVEnvironment.getInstance().acmsAddress = "http://localhost:28080/acms";
		AcmsMessageJSON json = AcmsClient.getInstance("ts", new PCNetworkAdapter()).uploadLogFile(sid, uploadFile, "2.0.0");
		
		System.out.println(" status=" + json.httpStatus + " message=" + StringUtil.join(",", json.errorMessage));
	}
	
	@Test
	public void contentRegist() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		String sid = "13711753344d3d0d8cff3fdab33bf2a8";
//		File uploadFile = new File("D:/var/PDF/image16.jpg.jpg");
		File uploadFile = new File("D:/Users/tsukada/Desktop/TEST_DATA/Agentec.pdf");
		ABVEnvironment.getInstance().acmsAddress = "http://web3.agentec.jp/acms";
		AcmsMessageJSON json = AcmsClient.getInstance("ts", new PCNetworkAdapter()).contentRegist(sid, uploadFile, true);
		
		System.out.println(" status=" + json.httpStatus + " message=" + StringUtil.join(",", json.errorMessage));
	}
	
	@Test
	public void checkSid() throws AcmsException, NetworkDisconnectedException, JSONValidationException {
		HttpRequestSender.testUserAgent = "Android";
		String sid = "764a0a02814b11552edd3c72014d0768";
		ABVEnvironment.getInstance().acmsAddress = "http://web3.agentec.jp/acms";
		
		System.out.println(AcmsClient.getInstance("ts", new PCNetworkAdapter()).checkSid(sid));
	}

	@Test
	public void serverTimeZone() throws AcmsException, NetworkDisconnectedException, JSONValidationException {
		HttpRequestSender.testUserAgent = "Android";
		ABVEnvironment.getInstance().acmsAddress = "http://web3.agentec.jp/sc";
		ServerTimeParameters param = new ServerTimeParameters("3084F8B2807C5BA9B11BF935FE6C5AC0");
		
		System.out.println(AcmsClient.getInstance("ts", new PCNetworkAdapter()).serverTimeZone(param));
//		System.out.println(AcmsClient.getInstance("ts", new PCNetworkAdapter()).serverTime(param));
	}

	@Test
	public void login() throws NetworkDisconnectedException, JSONValidationException, ABVException {
		HttpRequestSender.testUserAgent = "Android";
		ABVEnvironment.getInstance().acmsAddress = "http://web3.agentec.jp/acms";
		
		EnterpriseLoginParameters param = new EnterpriseLoginParameters("test", "123345", ABVEnvironment.AppId
				, "1.00", ABVEnvironment.DeviceTypeId, "devtokenhogehoge", "macmac", InstallType.Install);
		MemberInfoDto dto = new MemberInfoDto();
		
		AcmsClient.getInstance("ts", new PCNetworkAdapter()).enterpriseLogin(param, dto);
		System.out.println();
	}

	@Test
	public void contentDownloadLog() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		ABVEnvironment.getInstance().isReader = true;
		ABVEnvironment.getInstance().acmsAddress = "http://localhost:28080/acms";
		ContentDownloadLogParameters param = new ContentDownloadLogParameters(null, 10000004694L, new Timestamp(System.currentTimeMillis()), 0, 3, DownloadStatusType.Succeeded);
		boolean result = AcmsClient.getInstance(new PCNetworkAdapter()).contentDownloadLog(param);
		
		System.out.println(" result=" + result);
	}
	
	@Test
	public void contentReadingLog() throws AcmsException, NetworkDisconnectedException, JSONValidationException, IOException {
		
		HttpRequestSender.testUserAgent = "Android";
		ABVEnvironment.getInstance().isReader = true;
		ABVEnvironment.getInstance().acmsAddress = "http://localhost:28080/acms";
		ContentReadingLogParameters param = new ContentReadingLogParameters(null, 10000004694L, new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()), 1234, 3, null, null, ReadingLogMode.DEFAULT, null, null, null);
		boolean result = AcmsClient.getInstance(new PCNetworkAdapter()).contentReadingLog(param);
		
		System.out.println(" result=" + result);
	}
}
