package jp.agentec.adf.util;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

import jp.agentec.abook.abv.bl.remote.SocketAddressVO;
import jp.agentec.adf.util.CollectionUtil;

import org.junit.Test;

public class CollectionUtilTest {
	@Test
	public void contains() throws UnknownHostException {
		Set<Object> set = new HashSet<Object>();
		Object obj = new Object();
		set.add("AAA");
		set.add(obj);
		set.add("bbb");
		set.add("Dce");
		set.add("Afda");
		set.add(new SocketAddressVO(InetAddress.getByName("1.1.1.2"), 55, "user1"));
		assertTrue(CollectionUtil.contains(set, "bbb"));
		assertTrue(CollectionUtil.contains(set, "AAA"));
		assertTrue(CollectionUtil.contains(set, obj));
		assertFalse(CollectionUtil.contains(set, "bbfsdab"));
		assertFalse(CollectionUtil.contains(set, "AA"));
		assertFalse(CollectionUtil.contains(null, "AA"));
		assertFalse(CollectionUtil.contains(set, null));
		assertTrue(CollectionUtil.contains(set, new SocketAddressVO(InetAddress.getByName("1.1.1.2"), 55, "user1")));
	}

}
