package jp.agentec.abook.abv.ui.common.constant;

public enum ContentLocationType  {
	/**
	 * ダウンロードした内容を読む。
	 * @since 1.0.0
	 */
	Local(1),
	/**
	 * サーバの内容を読む。
	 * @since 1.0.0
	 */
	Server(2);
	private final int locationType;
	
	ContentLocationType(int locationType) {
		this.locationType = locationType;
	}
	
	/**
	 * サーバ、ローカルの番号を返します。
	 * @return　サーバ、ローカル番号です。
	 * @since 1.0.0
	 */
	public int type() {
		return locationType;
	}

	/**
	 * 指定した数字に対応するLocationTypeの値を返します。
	 * @param locationType 数字のコードです。
	 * @return　指定した数字に対応するLocationTypeの値です。
	 * @since 1.0.0
	 */
	public static ContentLocationType parse(int locationType) {
		ContentLocationType type;
		
		switch (locationType) {
		case 1:
			type = ContentLocationType.Local;
			break;
		case 2:
		default:
			type = ContentLocationType.Server;
			break;
		}
		
		return type;
	}
}
