package jp.agentec.abook.abv.ui.common.helper;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.PixelFormat;

public class ProgressDialogHelper {
	private static final String TAG = "ProgressDialogHelper";
	private static ProgressDialog progressDialog;

	public static void showProgressPopup(Activity act, boolean createNew, String msg) {
        if (progressDialog == null || createNew) {
            progressDialog = new ProgressDialog(act);
            progressDialog.setMessage(msg);
            progressDialog.setIndeterminate(true);
            progressDialog.setCancelable(false);
            if (progressDialog.getWindow() != null) {
                progressDialog.getWindow().setFormat(PixelFormat.TRANSPARENT);
            }
        }

        if (progressDialog != null && !progressDialog.isShowing()) {
			Logger.d(TAG, "progressDialog.show()");
			progressDialog.show();
		}
	}

	// loading...のプログレスバー
	public static void showProgressPopup(Activity act, boolean createNew) {
		showProgressPopup(act, createNew, act.getResources().getString(R.string.progress));
	}
	
	public static void closeProgressPopup() {
		if (progressDialog != null && progressDialog.isShowing()) {
			try {
				progressDialog.dismiss();
			}
			catch (Exception e) {
				Logger.e(TAG, "closeProgressPopup error. ", e);  // ignore
			}
		}
	}
}
