package jp.agentec.abook.abv.ui.common.view;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

/**
 * Created by tauch on 2016/06/03.
 */
public class ABVImageView extends ImageView {

	public ABVImageView(Context context) {
		super(context);
	}

	public ABVImageView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public ABVImageView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
	}

	@Override
	public void setPressed(boolean pressed) {
		super.setPressed(pressed);
		if (pressed) {
			setColorFilterForStatus(new PorterDuffColorFilter(0x55000000, PorterDuff.Mode.SRC_ATOP));
		} else {
			clearColor();
		}
	}

	private void setColorFilterForStatus(PorterDuffColorFilter porterDuffColorFilter) {
		Drawable background = getBackground();
		setColorFilter(porterDuffColorFilter);
		if (background != null) {
			background.setColorFilter(porterDuffColorFilter);
		}
	}

	private void clearColor() {
		clearColorFilter();
		Drawable background = getBackground();
		if (background != null) {
			background.clearColorFilter();
		}
	}

	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		if (enabled) {
			clearColor();
		} else {
			setColorFilterForStatus(new PorterDuffColorFilter(0x55cccccc, PorterDuff.Mode.SRC_ATOP));
		}
	}
}
