package jp.agentec.abook.abv.ui.common.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class ABVMarkingSettingPreviewView extends View {
	private Paint paint;
	private Paint framePaint;
	private int radius;

	public ABVMarkingSettingPreviewView(Context context) {
		super(context);
		initPaint();
	}

	public ABVMarkingSettingPreviewView(Context context, AttributeSet attrs) {
		super(context, attrs);
		initPaint();
	}

	@Override
	protected void onDraw(Canvas canvas) {
			canvas.drawCircle(getWidth() / 2, getHeight() / 2, radius, paint);
			canvas.drawCircle(getWidth() / 2, getHeight() / 2, radius + 1, framePaint);
	}

	public void setSelect(int width, int color) {

		paint.setColor(color);

		radius = width / 2;

		invalidate();
	}

	private void initPaint() {
		paint = new Paint();
		paint.setStrokeWidth(0);
		paint.setAntiAlias(true);

		framePaint = new Paint();
		framePaint.setStyle(Paint.Style.STROKE);
		framePaint.setStrokeWidth(2);
		framePaint.setColor(0xFF000000);
		framePaint.setAntiAlias(true);
	}
}
